<?php
require_once("JWT.php");
use Firebase\JWT\JWT;

class Example{
	/*
	 *		SETTINGS START
	 */

	const TLS_OFF = false;

	//getAccessTokenWithSertificate() function settings
	const CERTIFICATE_TOKEN_URL = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/token";
	const CERTIFICATE = "TestCert.pem";
	const CERTIFICATE_PASSWORD = "123123";
	const CERTIFICATE_CLIENT_ID = "urn:oauth2:d4ed79fa-8aaf-42aa-86ab-7d3db8defbdc";
	const CERTIFICATE_SCOPE = "urn:viss.apimanagement-apicall API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamStart API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamInfo";

	//multiply() and co function settings
	const SERVICE_BASE_ADDR = "https://wsogw1-dev-vraa.abc:8244/stable1/1/";
	const SOAP_SERVICE_BASE_ADDR = "https://wsogw1-dev-vraa.abc:8244/ISS-SIA.ABC-CalculationDataSync/v1.0";

	// Introspect() function settings
	const INTROSPECT_URL = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/introspect";
	const API_ID = "urn:viss.apimanagement";
	const API_SECRET = "secret";

	// transaction() function settings
	const TRANSACTION_URL = "https://app3-dev-vraa.abcsoftware.lv/ApiManagement.TransactionApi/transactions";
	const ESERVICE_URN = "URN:IVIS:100001:EP-EP186-v1-0";

	// Sertificate - https://stackoverflow.com/questions/42006100/how-to-connect-to-api-using-php-with-a-pfx-file-and-password
	/*               https://medium.com/better-programming/simple-example-using-json-web-tokens-with-php-and-jquery-c648a80854c
	 *		SETTINGS END

		 openssl pkcs12 -in TestCert.pfx -out TestCert.pem

	 */

	 // Class variables
	 public $token;
	 public $transactionId;

	 function __construct(){
		 $this->token = $this->getAccessTokenWithSertificate();
		 $this->transactionId = $this->startTransaction();
	 }

	function getAccessTokenWithSertificate(){

		$payload = [
			"sub" => self::CERTIFICATE_CLIENT_ID,
			"jti" => uniqid(),
			"nbf" => time(),
			"exp" => time() + 600,
			"iss" => self::CERTIFICATE_CLIENT_ID,
			"aud" => self::CERTIFICATE_TOKEN_URL
		];

		// Get public certificate
		$cert = openssl_x509_read(file_get_contents(self::CERTIFICATE));
		openssl_x509_export($cert, $str_cert);
		$pub_cert = str_replace([
			'-----BEGIN CERTIFICATE-----',
			'-----END CERTIFICATE-----',
			"\r\n",
			"\n",
		], [
			'',
			'',
			"\n",
			'',
		], $str_cert);

		//get thumbprint
		$fingerprint =  openssl_x509_fingerprint($cert,  $hash_algorithm = "sha1", $raw_output = true);
		
		$header = [
			"x5t" => base64_encode($fingerprint)
			//"x5c" => $pub_cert
		];

		$privateKey = openssl_pkey_get_private("file://" . __DIR__ . "\\" . self::CERTIFICATE, self::CERTIFICATE_PASSWORD);
		$jwt = JWT::encode($payload, $privateKey, "RS256", null, $header);
		openssl_free_key($privateKey);

		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, self::CERTIFICATE_TOKEN_URL);

		//Turn off all TLS security issues
		if (!self::TLS_OFF) {
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		}

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_HTTPHEADER, [
			"Content-Type: application/x-www-form-urlencoded"
		]);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query([
			"grant_type" => "client_credentials",
			"client_assertion_type" => "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
			"client_assertion" => $jwt,
			"scope" => self::CERTIFICATE_SCOPE
		]));

		//Getting result
		$result = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		$json = json_decode($result, true);
		if ($httpcode == 200) {
			return $json["access_token"];
		}

		echo "Error occurred to get AccessToken: " . $json["error"];
		if (array_key_exists("error_description", $json)) {
			echo $json["error_description"];
		}
		echo "</br>";

		return null;
	}

	public function multiply($multiplier, $multiplicant){

		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::SERVICE_BASE_ADDR."api/Calculator/Multiply");

		//Debug with Fiddler
		//curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');
		
		//Turn off all TLS security issues
		if (!self::TLS_OFF) {
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		}

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request & auth
		curl_setopt($curl, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json; charset=utf-8',
			'Authorization: Bearer ' . $this->token,
			'x-transactionId: ' . $this->transactionId
		]);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array(
			'Multiplier' => $multiplier,
			'Multiplicand' => $multiplicant
		)));

		//Getting result
		$result = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if ($httpcode == 200) {
			return $result;
		}

		echo "Error occurred to call multiply";
		return null;
	}

	public function divide($divident, $divisor){
		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::SERVICE_BASE_ADDR."api/Calculator/Divide");
		//Debug with Fiddler
		//curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');
		
		//Turn off all TLS security issues
		if (!self::TLS_OFF) {
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		}
		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request & auth
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json; charset=utf-8',
			'Authorization: Bearer ' . $this->token,
			'x-transactionId: ' . $this->transactionId
		));
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array(
			'Dividend' => $divident,
			'Divisor' => $divisor
		)));

		//Getting result
		$result = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if ($httpcode == 200) {
			return $result;
		}

		echo "Error occurred to call divide";
		return null;
	}

	public function soapMultiply($multiplier, $multiplicant){

		$envelope = <<< ENVELOPE_IND
		<s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/" xmlns:a="http://www.w3.org/2005/08/addressing" xmlns:u="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd">
			<s:Body xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
				<DefaultMethodSync xmlns="http://ivis.eps.gov.lv/ISS/IVISService/v1-0">
					<IVISRequest xmlns="http://ivis.eps.gov.lv/XMLSchemas/100001/IVIS/v1-0">
						<Header>
							<MessageID>73f30eaa-72e4-436d-a035-38652bc63c54</MessageID>
							<MessageType>URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation</MessageType>
							<TransactionID>$this->transactionId</TransactionID>
							<CorrelationID>e6813a08-46b3-4249-90ec-aa60b4addb2c</CorrelationID>
							<Destination>URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0</Destination>
						</Header>
						<Body>
							<Calculation xmlns="http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0">
								<Number1>$multiplier</Number1>
								<Number2>$multiplicant</Number2>
								<Operation>multiplication</Operation>
							</Calculation>
						</Body>
					</IVISRequest>
				</DefaultMethodSync>
			</s:Body>
		</s:Envelope>
ENVELOPE_IND;

		$curl = curl_init();

		// Fiddler proxy
		//curl_setopt($curl, CURLOPT_PROXY, '127.0.0.1:8888');

		curl_setopt($curl, CURLOPT_URL, self::SOAP_SERVICE_BASE_ADDR );

		//Turn off all TLS security issues
		if (!self::TLS_OFF) {
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		}

		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($curl, CURLOPT_POST,           true );
		curl_setopt($curl, CURLOPT_POSTFIELDS,     $envelope);
		curl_setopt($curl, CURLOPT_VERBOSE, TRUE);
		curl_setopt($curl, CURLOPT_HTTPHEADER, [
			'Authorization: Bearer ' . $this->token, 
			'x-transactionId: ' . $this->transactionId, 
			"Content-Type: text/xml; charset=utf-8",
			"SOAPAction: \"http://ivis.eps.gov.lv/ISS/IVISService/v1-0/DefaultMethodSync\""
			]);

		//Getting result & closing
		$result = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if ($httpcode == 200) {
			return htmlentities($result);
		}

		echo "Error occurred to call SOAP multiply";
		return null;
	}

	function getIntrospectResponse(){
		//Configuring URL & SSL
		$curl = curl_init();
		curl_setopt ($curl, CURLOPT_URL, self::INTROSPECT_URL);

		//Turn off all TLS security issues
		if (!self::TLS_OFF) {
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		}

		//Return result in string
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		//Configuring post request
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_HTTPHEADER, [
			"Content-Type: application/x-www-form-urlencoded"
		]);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query([
			'token' => $this->token,
			'client_id' => self::API_ID,
			'client_secret' => self::API_SECRET
		]));

		//Getting result
		$result = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		$json = json_decode($result, true);
		if ($httpcode == 200) {
			return $json;
		}

		echo "Error occurred to get introspection";
		return null;
	}

	// Start a transaction with a specific token
	function startTransaction(){
			// Initialize curl and set the API Endpoint url
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, self::TRANSACTION_URL);

			//Turn off all TLS security issues
			if (!self::TLS_OFF) {
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			}

			//Return result in string
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

			// set headers for the curl request
			curl_setopt($curl, CURLOPT_HTTPHEADER, [
				'Content-Type: application/json',
				'Accept: application/json',
				'Authorization: Bearer ' . $this->token,
			]);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(array('eserviceId' => self::ESERVICE_URN)));

			//Getting result
			$result = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$json = json_decode($result, true);
			curl_close($curl);

			if ($httpcode == 200) {
				return $json["result"];
			}

			echo "Error occurred to get transaction: " . $json["detail"] . "</br>";
			return null;
	}
}

$example = new Example();

echo "Access token: </br><strong>";
print_r($example->token);
echo "</strong></br></br>";

echo "Multiply result: </br><strong>";
echo $example->multiply(12, 12);
echo "</strong></br></br>";

echo "Divide result: </br><strong>";
echo $example->divide(12, 12);
echo "</strong></br></br>";

echo "Soap multiply result: </br><strong>";
echo $example->soapMultiply(12, 12);
echo "</strong></br>";

echo "Introspect result: </br><strong>";
$introspect = $example->getIntrospectResponse();
print_r($introspect);
// echo "</br> Legal entity: ";
// print_r($introspect['legalentity']);
echo "</strong></br></br>";

echo "Transaction: </br><strong>";
print_r($example->transactionId);
echo "</strong></br></br>";
?>
