﻿using Refit;
using System.Net.Http;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.Threading.Tasks;

namespace Viss.ApiManagement.Samples.TransactionApi
{
    public class TransactionApiClient
    {
        static RefitSettings settings = new RefitSettings
        {
            ContentSerializer = new SystemTextJsonContentSerializer(new JsonSerializerOptions
            {
                Converters = { new JsonStringEnumConverter(new EnumMemberJsonNamingPolicy()) }
            }),
        };

        public TransactionApiClient(HttpClient httpClient)
        {
            this.HttpClient = httpClient;
        }

        public HttpClient HttpClient { get; }

        public async Task<string> StartAsync(string eSercieId)
        {
            var transactionApi = Refit.RestService.For<ITransactionApi>(HttpClient, settings);
            var result = await transactionApi.StartAsync(eSercieId);
            return result.TransactionId;
        }
    }
}
