import CalculationReference.CalculationSyncStub;
import Enums.TokenType;
import TransactionApi.Structures.TransactionStatusResponse;
import TransactionApi.TransactionApi;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.NamedValue;
import org.apache.axis2.databinding.types.NormalizedString;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONObject;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import utils.ClientCredentialsRequest;
import utils.IdentityServerClient;
import utils.IntrospectRequest;
import utils.PasswordTokenRequest;

import javax.xml.stream.XMLStreamException;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;

import static io.jsonwebtoken.SignatureAlgorithm.RS256;

public class SoapExample {

    private final IdentityServerClient identityServerClient;
    private String baseAddress;
    private String transactionId;
    private String accessToken;

    public SoapExample() {
//        this.baseAddress = "https://wsogw1-dev-vraa.abc:8244/ISS-SIA.ABC-CalculationDataSync/v1.0/";
        this.baseAddress = "http://wsogw1-dev-vraa.abc:8281/ISS-SIA.ABC-CalculationDataSync/v1.0/";
        TokenType tokenTypeToUse = TokenType.JWT;
        String jwtClientId = "urn:oauth2:d4ed79fa-8aaf-42aa-86ab-7d3db8defbdc";
        String referenceClientId = "urn:oauth2:bd9f5fc0-e527-4ab1-8c8a-b870433435f2";
        String identityAddress = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/token";
        String introspectionAddress = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/introspect";
        String jwtPayloadAudience = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/token";
        String clientId = tokenTypeToUse == TokenType.JWT ? jwtClientId : referenceClientId;
        String clientSecret = "none";
        String userName = "abctest2";
        String password = "Sabla#1";
        String grantType = "password";
        String clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
        String grantTypeClient = "client_credentials";
        String clientAssertion = null;
        String scope = "urn:viss.apimanagement-apicall API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamStart API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamInfo";
        String transactionApiAddress = "https://app3-dev-vraa.abcsoftware.lv/ApiManagement.TransactionApi/";
        String eServiceId = "URN:IVIS:100001:EP-EP186-v1-0";

        String certificatePath ="src/main/resources/TestCert.pfx";
        String certificatePassword = "123";

        String introspectClientId = "API-SIA.ABC-Viss.UserProfile.Api-v1_0";
        String introspectClientSecret = "secret";

        try (FileInputStream stream = new FileInputStream(certificatePath)) {
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            char[] keyStorePassword = certificatePassword.toCharArray();
            store.load(stream, keyStorePassword);

            Enumeration<String> aliases = store.aliases();
            String alias = aliases.hasMoreElements() ? aliases.nextElement() : null;

            X509Certificate certificate = (X509Certificate) store.getCertificate(alias);
            byte[] certificateEncoded = certificate.getEncoded();
            String certificateEncodedBase64 = Base64.encodeBase64String(certificateEncoded);
            PrivateKey key = (PrivateKey) store.getKey(alias, keyStorePassword);

            Date currentTime = new Date();
            JwtBuilder builder = Jwts.builder()
                    .id(UUID.randomUUID().toString())
                    .subject(clientId)
                    .issuer(clientId)
                    .audience().add(jwtPayloadAudience).and()
                    .expiration(Date.from(currentTime.toInstant().plus(Duration.ofHours(5))))
                    .notBefore(new Date())
                    .header().add("x5c", certificateEncodedBase64)
                    .and()
                    .signWith(key, RS256);
            clientAssertion = builder.compact();
        } catch (UnrecoverableKeyException | KeyStoreException | NoSuchProviderException | NoSuchAlgorithmException |
                 CertificateException | IOException e) {
            e.printStackTrace();
        }

        this.identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest(identityAddress, clientId, clientSecret, userName, password, grantType, scope),
                new ClientCredentialsRequest(identityAddress, clientId, clientSecret, clientAssertionType, clientAssertion, grantTypeClient, scope),
                new IntrospectRequest(introspectionAddress, introspectClientId, introspectClientSecret));
        accessToken = identityServerClient.getAccessTokenClientCredentials().get();
        if (tokenTypeToUse == TokenType.JWT) {
            System.out.println("Introspection not supported for JWT tokens");
        } else {
            JSONObject introspectResponse = identityServerClient.getIntrospection(accessToken).get();
            System.out.println("Introspection response for token " + accessToken);
            System.out.println(introspectResponse.toString());
        }
        System.out.println();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(transactionApiAddress)
                .addConverterFactory(GsonConverterFactory.create(new GsonBuilder().create()))
                .build();
        TransactionApi transactionApi = retrofit.create(TransactionApi.class);
        try {
            TransactionStatusResponse transactionStatus = transactionApi.Start(eServiceId, "Bearer " + accessToken).execute().body();
            transactionId = transactionStatus.getTansactionId();
            System.out.println("Transaction started with id " + transactionId);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void Run() {
        Multiply();
        Divide();
    }

    private void Multiply() {
        try {
            CalculationSyncStub.RequestHeaderStructure header = new CalculationSyncStub.RequestHeaderStructure();

            CalculationSyncStub.UUIDType messageId = new CalculationSyncStub.UUIDType();
            messageId.setUUIDType("6cafe2c6-9834-47ad-b710-be8033710b02");
            header.setMessageID(messageId);

            CalculationSyncStub.URNType messageType = new CalculationSyncStub.URNType();
            messageType.setURNType("URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation");
            header.setMessageType(messageType);

            CalculationSyncStub.URNType transactionID = new CalculationSyncStub.URNType();
            transactionID.setURNType(transactionId);
            header.setTransactionID(transactionID);

            CalculationSyncStub.UUIDType correlationID = new CalculationSyncStub.UUIDType();
            correlationID.setUUIDType("f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e");
            header.setCorrelationID(correlationID);

            CalculationSyncStub.URNType destination = new CalculationSyncStub.URNType();
            destination.setURNType("URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0");
            header.setDestination(destination);

            CalculationSyncStub.URNType milestoneID = new CalculationSyncStub.URNType();
            milestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setMilestoneID(milestoneID);

            CalculationSyncStub.URNType nextMilestoneID = new CalculationSyncStub.URNType();
            nextMilestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setNextMilestoneID(nextMilestoneID);

            CalculationSyncStub.URNType responseEndPoint = new CalculationSyncStub.URNType();
            responseEndPoint.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setResponseEndPoint(responseEndPoint);

            CalculationSyncStub.ParticipantStructure participant = new CalculationSyncStub.ParticipantStructure();
            CalculationSyncStub.URNType systemID = new CalculationSyncStub.URNType();
            systemID.setURNType("URN:IVIS:100001:PORTAL-Unknown");
            participant.setSystemID(systemID);

            CalculationSyncStub.ParticipantStructureChoice_type0 participantStructureChoice_type0 = new CalculationSyncStub.ParticipantStructureChoice_type0();
            CalculationSyncStub.InhabitantStructure inhabitant = new CalculationSyncStub.InhabitantStructure();

            CalculationSyncStub.PersonCodeType personCode = new CalculationSyncStub.PersonCodeType();
            personCode.setPersonCodeType("09016711212");
            inhabitant.setPersonCode(personCode);

            CalculationSyncStub.PersonIDStructure personID = new CalculationSyncStub.PersonIDStructure();
            personID.setScheme(new NormalizedString("urn:ivis:100001:name.id-viss"));
            personID.setNormalizedString(new NormalizedString("PK:09016711212"));
            inhabitant.setPersonID(personID);

            CalculationSyncStub.PersonFullNameStructure personFullName = new CalculationSyncStub.PersonFullNameStructure();
            CalculationSyncStub.FirstNameType firstName = new CalculationSyncStub.FirstNameType();
            firstName.setFirstNameType(new NormalizedString("Aivars"));
            personFullName.setFirstName(firstName);
            CalculationSyncStub.LastNameType lastName = new CalculationSyncStub.LastNameType();
            lastName.setLastNameType(new NormalizedString("Rožkalns"));
            personFullName.setLastName(lastName);
            inhabitant.setFullName(personFullName);

            participantStructureChoice_type0.setInhabitant(inhabitant);
            participant.setParticipantStructureChoice_type0(participantStructureChoice_type0);
            header.setSender(participant);

            CalculationSyncStub.Body_type0 body = new CalculationSyncStub.Body_type0();
            body.setExtraElement(AXIOMUtil.stringToOM(
                    "<Calculation xmlns=\"http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0\">" +
                            "<Number1>5</Number1>" +
                            "<Number2>6</Number2>" +
                            "<Operation>multiplication</Operation>" +
                            "</Calculation>"));

            CalculationSyncStub.IVISRequestStructure request = new CalculationSyncStub.IVISRequestStructure();
            request.setHeader(header);
            request.setBody(body);
            CalculationSyncStub.DefaultMethodSync defaultMethodSync = new CalculationSyncStub.DefaultMethodSync();
            defaultMethodSync.setIVISRequest(request);

            CalculationSyncStub client = new CalculationSyncStub(this.baseAddress);
            ServiceClient sc = client._getServiceClient();

            Options options = new Options();
            List<NamedValue> namedValuePairs = new ArrayList<NamedValue>();
            namedValuePairs.add(new NamedValue("Authorization", "Bearer " + accessToken));
            namedValuePairs.add(new NamedValue("x-transactionId", transactionId));
            options.setProperty("HTTP_HEADERS", namedValuePairs);
            options.setTo(new EndpointReference(this.baseAddress));
            sc.setOptions(options);

            CalculationSyncStub.DefaultMethodSyncResponse response = client.defaultMethodSync(defaultMethodSync);
            System.out.println(response.getIVISResponse().getBody().getExtraElement().toString());
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Divide() {
        try {
            CalculationSyncStub.RequestHeaderStructure header = new CalculationSyncStub.RequestHeaderStructure();

            CalculationSyncStub.UUIDType messageId = new CalculationSyncStub.UUIDType();
            messageId.setUUIDType("6cafe2c6-9834-47ad-b710-be8033710b02");
            header.setMessageID(messageId);

            CalculationSyncStub.URNType messageType = new CalculationSyncStub.URNType();
            messageType.setURNType("URN:IVIS:100001:XSD-Testing-TestISServise-v1-0-TYPE-Calculation");
            header.setMessageType(messageType);

            CalculationSyncStub.URNType transactionID = new CalculationSyncStub.URNType();
            transactionID.setURNType(transactionId);
            header.setTransactionID(transactionID);

            CalculationSyncStub.UUIDType correlationID = new CalculationSyncStub.UUIDType();
            correlationID.setUUIDType("f4ceae8a-dfd9-48b3-a0b6-5d990aaac86e");
            header.setCorrelationID(correlationID);

            CalculationSyncStub.URNType destination = new CalculationSyncStub.URNType();
            destination.setURNType("URN:IVIS:100001:ISS-SIA.ABC-CalculationDataSync-v1-0");
            header.setDestination(destination);

            CalculationSyncStub.URNType milestoneID = new CalculationSyncStub.URNType();
            milestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setMilestoneID(milestoneID);

            CalculationSyncStub.URNType nextMilestoneID = new CalculationSyncStub.URNType();
            nextMilestoneID.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setNextMilestoneID(nextMilestoneID);

            CalculationSyncStub.URNType responseEndPoint = new CalculationSyncStub.URNType();
            responseEndPoint.setURNType("URN:IVIS:100001:EP-EdkTester-v1-0-MS-CallCalcSync");
            header.setResponseEndPoint(responseEndPoint);

            CalculationSyncStub.ParticipantStructure participant = new CalculationSyncStub.ParticipantStructure();
            CalculationSyncStub.URNType systemID = new CalculationSyncStub.URNType();
            systemID.setURNType("URN:IVIS:100001:PORTAL-Unknown");
            participant.setSystemID(systemID);

            CalculationSyncStub.ParticipantStructureChoice_type0 participantStructureChoice_type0 = new CalculationSyncStub.ParticipantStructureChoice_type0();
            CalculationSyncStub.InhabitantStructure inhabitant = new CalculationSyncStub.InhabitantStructure();

            CalculationSyncStub.PersonCodeType personCode = new CalculationSyncStub.PersonCodeType();
            personCode.setPersonCodeType("09016711212");
            inhabitant.setPersonCode(personCode);

            CalculationSyncStub.PersonIDStructure personID = new CalculationSyncStub.PersonIDStructure();
            personID.setScheme(new NormalizedString("urn:ivis:100001:name.id-viss"));
            personID.setNormalizedString(new NormalizedString("PK:09016711212"));
            inhabitant.setPersonID(personID);

            CalculationSyncStub.PersonFullNameStructure personFullName = new CalculationSyncStub.PersonFullNameStructure();
            CalculationSyncStub.FirstNameType firstName = new CalculationSyncStub.FirstNameType();
            firstName.setFirstNameType(new NormalizedString("Aivars"));
            personFullName.setFirstName(firstName);
            CalculationSyncStub.LastNameType lastName = new CalculationSyncStub.LastNameType();
            lastName.setLastNameType(new NormalizedString("Rožkalns"));
            personFullName.setLastName(lastName);
            inhabitant.setFullName(personFullName);

            participantStructureChoice_type0.setInhabitant(inhabitant);
            participant.setParticipantStructureChoice_type0(participantStructureChoice_type0);
            header.setSender(participant);

            CalculationSyncStub.Body_type0 body = new CalculationSyncStub.Body_type0();
            body.setExtraElement(AXIOMUtil.stringToOM(
                    "<Calculation xmlns=\"http://ivis.eps.gov.lv/XMLSchemas/100000/TestISServise/v1-0\">" +
                            "<Number1>10</Number1>" +
                            "<Number2>2</Number2>" +
                            "<Operation>division</Operation>" +
                            "</Calculation>"));

            CalculationSyncStub.IVISRequestStructure request = new CalculationSyncStub.IVISRequestStructure();
            request.setHeader(header);
            request.setBody(body);
            CalculationSyncStub.DefaultMethodSync defaultMethodSync = new CalculationSyncStub.DefaultMethodSync();
            defaultMethodSync.setIVISRequest(request);

            CalculationSyncStub client = new CalculationSyncStub(this.baseAddress);
            ServiceClient sc = client._getServiceClient();

            Options options = new Options();
            List<NamedValue> namedValuePairs = new ArrayList<NamedValue>();
            namedValuePairs.add(new NamedValue("Authorization", "Bearer " + accessToken));
            namedValuePairs.add(new NamedValue("x-transactionId", transactionId));
            options.setProperty("HTTP_HEADERS", namedValuePairs);
            options.setTo(new EndpointReference(this.baseAddress));
            sc.setOptions(options);

            CalculationSyncStub.DefaultMethodSyncResponse response = client.defaultMethodSync(defaultMethodSync);
            System.out.println(response.getIVISResponse().getBody().getExtraElement().toString());
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
