import Enums.TokenType;
import TransactionApi.Structures.TransactionStatusResponse;
import TransactionApi.TransactionApi;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONObject;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import utils.ClientCredentialsRequest;
import utils.IdentityServerClient;
import utils.IntrospectRequest;
import utils.PasswordTokenRequest;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;

import static io.jsonwebtoken.SignatureAlgorithm.RS256;

public class RestExample {

    private final IdentityServerClient identityServerClient;
    private String baseAddress;
    private String transactionId;
    private String accessToken;

    public RestExample() {
        this.baseAddress = "http://wsogw1-dev-vraa.abc:8281/stable1/1/";
        TokenType tokenTypeToUse = TokenType.JWT;
        String jwtClientId = "urn:oauth2:d4ed79fa-8aaf-42aa-86ab-7d3db8defbdc";
        String referenceClientId = "urn:oauth2:bd9f5fc0-e527-4ab1-8c8a-b870433435f2";
        String identityAddress = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/token";
        String introspectionAddress = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/introspect";
        String jwtPayloadAudience = "https://viss-portal-dev-vraa.abcsoftware.lv/IamIdentity.Server/connect/token";
        //APP-SIA_ABC-TestApp-v10
        String clientId = tokenTypeToUse == TokenType.JWT ? jwtClientId : referenceClientId;
        String clientSecret = "none";
        String userName = "abctest2";
        String password = "Sabla#1";
        String grantType = "password";
        String clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
        String grantTypeClient = "client_credentials";
        String clientAssertion = null;
        String scope = "urn:viss.apimanagement-apicall API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamStart API-SIA.ABC-Viss.ApiManagement.TransactionApi-v1_0-IamInfo";
        String transactionApiAddress = "https://app3-dev-vraa.abcsoftware.lv/ApiManagement.TransactionApi/";
        String eServiceId = "URN:IVIS:100001:EP-EP186-v1-0";

        String certificatePath ="src/main/resources/TestCert.pfx";
        String certificatePassword = "123";

        String introspectClientId = "API-SIA.ABC-Viss.UserProfile.Api-v1_0";
        String introspectClientSecret = "secret";

        // Print the current working directory
        System.out.println("Current Working Directory: " + System.getProperty("user.dir"));
        try (FileInputStream stream = new FileInputStream(certificatePath)){
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            char[] keyStorePassword = certificatePassword.toCharArray();
            store.load(stream, keyStorePassword);

            Enumeration<String> aliases = store.aliases();
            String alias = aliases.hasMoreElements() ? aliases.nextElement() : null;

            X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
            byte[] certificateEncoded = certificate.getEncoded();
            String certificateEncodedBase64 = Base64.encodeBase64String(certificateEncoded);
            PrivateKey key = (PrivateKey) store.getKey(alias, keyStorePassword);

            Date currentTime = new Date();
            JwtBuilder builder = Jwts.builder()
                    .id(UUID.randomUUID().toString())
                    .subject(clientId)
                    .issuer(clientId)
                    .audience().add(jwtPayloadAudience).and()
                    .expiration(Date.from(currentTime.toInstant().plus(Duration.ofHours(5))))
                    .notBefore( new Date())
                    .header().add("x5c", certificateEncodedBase64)
                    .and()
                    .signWith(key, RS256);
            clientAssertion = builder.compact();
        } catch (IOException | CertificateException | NoSuchAlgorithmException | UnrecoverableKeyException |
                 KeyStoreException | NoSuchProviderException e) {
            e.printStackTrace();
        }

        this.identityServerClient = new IdentityServerClient(
                new PasswordTokenRequest(identityAddress, clientId, clientSecret, userName, password, grantType, scope ),
                new ClientCredentialsRequest(identityAddress, clientId, clientSecret, clientAssertionType, clientAssertion, grantTypeClient, scope),
                new IntrospectRequest(introspectionAddress, introspectClientId, introspectClientSecret));

        accessToken = identityServerClient.getAccessTokenClientCredentials().get(); //identityServerClient.getAccessTokenClientCredentials()
        if(tokenTypeToUse == TokenType.JWT){
            System.out.println("Introspection not supported for JWT tokens");
        } else {
            JSONObject introspectResponse = identityServerClient.getIntrospection(accessToken).get();
            System.out.println("Introspection response for token " + accessToken);
            System.out.println(introspectResponse.toString());
        }

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(transactionApiAddress)
                .addConverterFactory(GsonConverterFactory.create(new GsonBuilder().create()))
                .build();
        TransactionApi transactionApi = retrofit.create(TransactionApi.class);
        try {
            TransactionStatusResponse transactionStatus = transactionApi.Start(eServiceId, "Bearer " + accessToken).execute().body();
            transactionId = transactionStatus.getTansactionId();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }


    public void Run() {
        Multiply();
        Divide();
    }

    private void Multiply() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Multiplier", 12);
            jsonObject.put("Multiplicand", 12);


            HttpClient client = HttpClient.newHttpClient();

            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(baseAddress + "api/Calculator/Multiply"))
                    .header("Content-Type", "application/json")
                    .header("Authorization", "Bearer " + accessToken)
                    .header("x-transactionId", transactionId)
                    .POST(HttpRequest.BodyPublishers.ofString(jsonObject.toString(), StandardCharsets.UTF_8))
                    .build();

            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());

            int statusCode = response.statusCode();
            if (statusCode == 200) {
                System.out.println(response.body());
            } else {
                System.out.println("Response:");
                System.out.println(response.body());
                throw new IOException("Something went wrong when requesting Multiply. Error code: " + statusCode);
            }

        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void Divide() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Dividend", 10);
            jsonObject.put("Divisor", 2);

            HttpClient client = HttpClient.newHttpClient();

            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(baseAddress + "api/Calculator/Divide"))
                    .header("Content-Type", "application/json")
                    .header("Authorization", "Bearer " + accessToken)
                    .header("x-transactionId", transactionId)
                    .POST(HttpRequest.BodyPublishers.ofString(jsonObject.toString(), StandardCharsets.UTF_8))
                    .build();

            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());

            int statusCode = response.statusCode();
            if (statusCode == 200) {
                System.out.println(response.body());
            } else {
                System.out.println("Response:");
                System.out.println(response.body());
                throw new IOException("Something went wrong when requesting Divide. Error code: " + statusCode);
            }

        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}
