/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.io.IOException;
import java.io.OutputStream;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ObjectFactory;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.SendAttachmentSectionInput;
import vraa.div.client.EvenlyBufferedOutputStream;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;

public class LargeFileSendOutputStream
extends OutputStream {
    OutputStream writeStream;
    LargeFileSendActualStream actualStream;

    public LargeFileSendOutputStream(String serverId, String contentId, IntegrationClientContext context) {
        this.actualStream = new LargeFileSendActualStream(serverId, contentId, context);
        this.writeStream = new EvenlyBufferedOutputStream(this.actualStream, 0x400000);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.writeStream.write(buffer, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.writeStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writeStream != null) {
            this.writeStream.close();
            this.writeStream = null;
        }
        if (this.actualStream != null) {
            this.actualStream.close();
            this.actualStream = null;
        }
        super.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    class LargeFileSendActualStream
    extends OutputStream {
        private String serverId;
        private String contentId;
        private IntegrationClientContext context;
        private int index;
        private boolean needClose;
        private int lastLength;
        private RuntimeException lastError;

        public LargeFileSendActualStream(String serverId, String contentId, IntegrationClientContext context) {
            this.serverId = serverId;
            this.contentId = contentId;
            this.context = context;
        }

        @Override
        public void write(byte[] buffer, int offset, int count) {
            if (this.lastError != null) {
                throw this.lastError;
            }
            if (count > 0) {
                byte[] content;
                if (count > 0x400000) {
                    String msg = "largeFileSendActualStreamInvalidCount";
                    throw ExceptionBuilder.Technical(msg, new Object[0]);
                }
                if (count == 0x400000 && offset == 0 && buffer.length == count) {
                    content = buffer;
                } else {
                    content = new byte[count];
                    System.arraycopy(buffer, offset, content, 0, count);
                }
                SendAttachmentSectionInput sendRequest = new SendAttachmentSectionInput();
                ObjectFactory of = new ObjectFactory();
                sendRequest.setMessageId(of.createSendAttachmentSectionInputMessageId(this.serverId));
                sendRequest.setContentId(of.createSendAttachmentSectionInputContentId(this.contentId));
                sendRequest.setSectionIndex(Long.valueOf(this.index));
                sendRequest.setContents(of.createSendAttachmentSectionInputContents(content));
                try {
                    this.context.call().sendAttachmentSection(sendRequest);
                }
                catch (RuntimeException ex) {
                    this.lastError = ex;
                    throw ex;
                }
                this.needClose = true;
                this.lastLength = count;
                ++this.index;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.lastError == null && this.needClose && this.lastLength % 0x400000 == 0) {
                SendAttachmentSectionInput sendRequest = new SendAttachmentSectionInput();
                ObjectFactory of = new ObjectFactory();
                sendRequest.setMessageId(of.createSendAttachmentSectionInputMessageId(this.serverId));
                sendRequest.setContentId(of.createSendAttachmentSectionInputContentId(this.contentId));
                sendRequest.setSectionIndex(Long.valueOf(this.index));
                this.context.call().sendAttachmentSection(sendRequest);
                this.needClose = false;
            }
            super.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }
}

