/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.AddressStructure;
import vraa.div.client.ForeignAddress;
import vraa.div.client.LatvianAddress;

public class Address {
    private ForeignAddress foreign;
    private boolean foreignAddress;
    private boolean latvianAddress;
    private LatvianAddress latvian;

    public Address(ForeignAddress foreignAddress) {
        this.foreign = foreignAddress;
        this.foreignAddress = true;
    }

    public Address(LatvianAddress latvianAddress) {
        this.latvian = latvianAddress;
        this.latvianAddress = true;
    }

    public ForeignAddress getForeign() {
        return this.foreign;
    }

    public boolean isForeignAddress() {
        return this.foreignAddress;
    }

    public boolean isLatvianAddress() {
        return this.latvianAddress;
    }

    public LatvianAddress getLatvian() {
        return this.latvian;
    }

    Address(AddressStructure schemaType) {
        this.setSchemaType(schemaType);
    }

    AddressStructure getSchemaType() {
        AddressStructure addr = new AddressStructure();
        if (this.latvianAddress) {
            addr.setAddressLVA(this.latvian.getSchemaType());
        } else {
            addr.setForeignAddress(this.foreign.getSchemaType());
        }
        return addr;
    }

    void setSchemaType(AddressStructure addr) {
        if (addr.getAddressLVA() != null) {
            this.latvian = new LatvianAddress();
            this.latvian.setSchemaType(addr.getAddressLVA());
            this.latvianAddress = true;
        } else {
            this.foreign = new ForeignAddress();
            this.foreign.setSchemaType(addr.getForeignAddress());
            this.foreignAddress = true;
        }
    }
}

