/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.IntegrationMessage;
import vraa.div.client.MessageRecipient;
import vraa.div.client.mailbox.FileDecryptKeyInfo;

public class FileDecryptInfo {
    private String[] thumbprints;
    private String[] encryptedKeys;
    private Boolean encrypted;

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public FileDecryptInfo(IntegrationMessage message) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        this.thumbprints = new String[message.getRecipients().size()];
        this.encryptedKeys = new String[message.getRecipients().size()];
        for (int i = 0; i < message.getRecipients().size(); ++i) {
            MessageRecipient recipient = (MessageRecipient)message.getRecipients().get(i);
            this.thumbprints[i] = recipient.getCertificateThumbprint();
            this.encryptedKeys[i] = recipient.getEncryptedKey();
        }
        this.encrypted = message.getEncryptionSetting();
    }

    public FileDecryptKeyInfo getEncryptedKey(IntegrationClientContext clientContext) {
        FileDecryptKeyInfo result = null;
        if (this.encrypted != null && this.encrypted.booleanValue()) {
            for (int i = 0; i < this.thumbprints.length; ++i) {
                if (!clientContext.getConfiguration().getCertificates().containsKey(this.thumbprints[i].toLowerCase())) continue;
                result = new FileDecryptKeyInfo();
                result.setEncryptedKey(this.encryptedKeys[i]);
                result.setCertificateThumbprint(this.thumbprints[i]);
                break;
            }
        }
        return result;
    }
}

