/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.configuration;

import java.io.FileInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import vraa.div.client.ClientCertificateReference;
import vraa.div.client.ClientConfiguration;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.FileTypeConfiguration;
import vraa.div.client.StoreLocation;
import vraa.div.client.Utils;
import vraa.div.client.configuration.InternalCertificate;
import vraa.div.client.configuration.InternalFileType;
import vraa.div.client.configuration.InternalKeyStoreCallbackHandler;

public class InternalConfiguration {
    private URI serviceUri;
    private int timeout;
    private HashMap<String, InternalCertificate> certificates = new HashMap();
    private InternalCertificate defaultCertificate;
    private HashMap<String, InternalFileType> fileTypes = new HashMap();
    private boolean compressByDefault;
    private boolean encryptByDefault;
    private String logPath;
    private String srsEinvoiceEaddresse;

    public final URI getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(URI serviceUri) {
        this.serviceUri = serviceUri;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final HashMap<String, InternalCertificate> getCertificates() {
        return this.certificates;
    }

    public final InternalCertificate getDefaultCertificate() {
        return this.defaultCertificate;
    }

    public final HashMap<String, InternalFileType> getFileTypes() {
        return this.fileTypes;
    }

    public final boolean getCompressByDefault() {
        return this.compressByDefault;
    }

    public final boolean getEncryptByDefault() {
        return this.encryptByDefault;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getSrsEinvoiceEaddresse() {
        return this.srsEinvoiceEaddresse;
    }

    public void setSrsEinvoiceEaddresse(String srsEinvoiceEaddresse) {
        this.srsEinvoiceEaddresse = srsEinvoiceEaddresse;
    }

    public static InternalConfiguration fromClientConfig(ClientConfiguration configuration) {
        int i;
        InternalConfiguration internalConfig = new InternalConfiguration();
        URI uri = null;
        try {
            uri = new URI(configuration.getServiceAddress());
            if (!uri.isAbsolute()) {
                throw ExceptionBuilder.Client("BL.BIB.003", configuration.getServiceAddress());
            }
            if (!uri.getScheme().toLowerCase().startsWith("http")) {
                throw ExceptionBuilder.Client("BL.BIB.004", uri.getScheme());
            }
        }
        catch (URISyntaxException e) {
            throw ExceptionBuilder.Client("BL.BIB.003", configuration.getServiceAddress());
        }
        if (configuration.getTimeout() <= 0 || configuration.getTimeout() >= 3600) {
            throw ExceptionBuilder.Client("BL.BIB.029", new Object[0]);
        }
        internalConfig.timeout = configuration.getTimeout();
        internalConfig.serviceUri = uri;
        internalConfig.logPath = configuration.getLogPath();
        internalConfig.srsEinvoiceEaddresse = configuration.getSrsEinvoiceEaddresse();
        if (configuration.getCertificates().size() == 0) {
            throw ExceptionBuilder.Client("BL.BIB.005", new Object[0]);
        }
        KeyStore localStore = null;
        KeyStore userStore = null;
        try {
            i = -1;
            for (ClientCertificateReference certRef : configuration.getCertificates()) {
                List<KeyStore.Entry> result;
                ++i;
                if (certRef.getThumbprint() == null || certRef.getThumbprint().length() == 0) {
                    throw ExceptionBuilder.Client("BL.BIB.006", i);
                }
                String thumbprint = certRef.getThumbprint().replaceAll(" ", "").toLowerCase();
                if (internalConfig.getCertificates().containsKey(thumbprint)) {
                    throw ExceptionBuilder.Client("BL.BIB.007", thumbprint);
                }
                KeyStore store = null;
                StoreLocation storeLoc = certRef.getStore();
                switch (storeLoc) {
                    case LocalMachine: {
                        store = localStore;
                        break;
                    }
                    case CurrentUser: {
                        store = userStore;
                    }
                }
                if (store == null) {
                    switch (storeLoc) {
                        case LocalMachine: 
                        case CurrentUser: {
                            store = KeyStore.getInstance(certRef.getStore().getLocation());
                            store.load(null, null);
                            switch (storeLoc) {
                                case LocalMachine: {
                                    localStore = store;
                                    break;
                                }
                                case CurrentUser: {
                                    userStore = store;
                                }
                            }
                            break;
                        }
                        case JKS: 
                        case PKCS12: {
                            store = KeyStore.getInstance(certRef.getStore().getLocation());
                            store.load(new FileInputStream(certRef.getStoreFile()), certRef.getPassword());
                        }
                    }
                }
                if ((result = Utils.findByThumbprint(store, thumbprint, certRef.getPassword())).size() == 0) {
                    throw ExceptionBuilder.Client("BL.BIB.008", new Object[]{thumbprint, storeLoc});
                }
                if (result.size() > 1) {
                    throw ExceptionBuilder.Client("BL.BIB.009", new Object[]{thumbprint, storeLoc});
                }
                KeyStore.Entry cert = result.get(0);
                if (!(cert instanceof KeyStore.PrivateKeyEntry)) {
                    throw ExceptionBuilder.Client("BL.BIB.010", thumbprint);
                }
                InternalCertificate internalCert = new InternalCertificate();
                internalCert.setThumbprint(thumbprint);
                internalCert.setStore(storeLoc);
                internalCert.setEntry((KeyStore.PrivateKeyEntry)cert);
                internalConfig.getCertificates().put(thumbprint, internalCert);
                InternalCertificate defCert = internalConfig.defaultCertificate;
                Date now = new Date();
                if (internalCert.getCertificate().getNotBefore().compareTo(now) >= 0 || internalCert.getCertificate().getNotAfter().compareTo(now) <= 0 || defCert != null && defCert.getCertificate().getNotAfter().compareTo(internalCert.getCertificate().getNotAfter()) >= 0) continue;
                internalConfig.defaultCertificate = internalCert;
                InternalKeyStoreCallbackHandler.setdefaultCert(internalCert);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (internalConfig.defaultCertificate == null) {
            throw ExceptionBuilder.Client("BL.BIB.011", new Object[0]);
        }
        for (i = 0; i < configuration.getFileTypes().size(); ++i) {
            FileTypeConfiguration fileInfo = configuration.getFileTypes().get(i);
            String extension = null;
            if (fileInfo.getExtension() != null && (extension = fileInfo.getExtension().trim().toLowerCase()).startsWith(".")) {
                extension = extension.substring(1);
            }
            if (fileInfo.getExtension() == null || fileInfo.getExtension().length() == 0) {
                throw ExceptionBuilder.Client("BL.BIB.012", i);
            }
            if (internalConfig.getFileTypes().containsKey(extension)) {
                throw ExceptionBuilder.Client("BL.BIB.013", extension);
            }
            InternalFileType intFileInfo = new InternalFileType();
            intFileInfo.setCompress(fileInfo.getCompress());
            intFileInfo.setMimeType(fileInfo.getMimeType());
            internalConfig.getFileTypes().put(extension, intFileInfo);
        }
        internalConfig.compressByDefault = configuration.isCompressByDefault();
        internalConfig.encryptByDefault = configuration.isEncryptByDefault();
        return internalConfig;
    }
}

