/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.PrivatePersonDataStructure;
import vraa.div.client.Address;
import vraa.div.client.ContactInfo;
import vraa.div.client.Person;
import vraa.div.client.Utils;

public class PrivatePerson
extends Person {
    private Address address;
    private String identityNumber;
    private String otherIdentifyingInfo;

    public PrivatePerson() {
    }

    public PrivatePerson(String name, String surname) {
        this.setName(name);
        this.setSurname(surname);
    }

    public PrivatePerson(Person person) {
        this.setName(person.getName());
        this.setSurname(person.getSurname());
        this.setContactInfo(person.getContactInfo());
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setIdentityNumber(String identityNumber) {
        this.identityNumber = Utils.ClientTrim(identityNumber);
    }

    public String getIdentityNumber() {
        return this.identityNumber;
    }

    public void setOtherIdentifyingInfo(String otherIdentifyingInfo) {
        this.otherIdentifyingInfo = Utils.ClientTrim(otherIdentifyingInfo);
    }

    public String getOtherIdentifyingInfo() {
        return this.otherIdentifyingInfo;
    }

    PrivatePersonDataStructure getSchemaType() {
        PrivatePersonDataStructure schemaType = new PrivatePersonDataStructure();
        schemaType.setName(this.getName());
        schemaType.setSurname(this.getSurname());
        if (this.address != null) {
            schemaType.setAddress(this.address.getSchemaType());
        }
        schemaType.setIdentityNumber(this.identityNumber);
        schemaType.setOtherIdentifyingInfo(this.otherIdentifyingInfo);
        if (this.getContactInfo() != null) {
            schemaType.setContactInfo(this.getContactInfo().getSchemaType());
        }
        return schemaType;
    }

    void setSchemaType(PrivatePersonDataStructure schemaType) {
        this.setName(schemaType.getName());
        this.setSurname(schemaType.getSurname());
        if (schemaType.getAddress() != null) {
            this.address = new Address(schemaType.getAddress());
        }
        this.identityNumber = schemaType.getIdentityNumber();
        this.otherIdentifyingInfo = schemaType.getOtherIdentifyingInfo();
        if (schemaType.getContactInfo() != null) {
            this.setContactInfo(new ContactInfo());
            this.getContactInfo().setSchemaType(schemaType.getContactInfo());
        }
    }
}

