/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.OfficerStructure;
import vraa.div.client.ContactInfo;
import vraa.div.client.Person;
import vraa.div.client.Utils;

public class Officer
extends Person {
    private String officerPosition;

    public Officer() {
    }

    public Officer(String name, String surname) {
        this.setName(name);
        this.setSurname(surname);
    }

    public Officer(String name, String surname, String position) {
        this.setName(name);
        this.setSurname(surname);
        this.officerPosition = position;
    }

    public Officer(Person person) {
        this.setName(person.getName());
        this.setSurname(person.getSurname());
        this.setContactInfo(person.getContactInfo());
    }

    public void setOfficerPosition(String officerPosition) {
        this.officerPosition = Utils.ClientTrim(officerPosition);
    }

    public String getOfficerPosition() {
        return this.officerPosition;
    }

    OfficerStructure getSchemaType() {
        OfficerStructure s = new OfficerStructure();
        s.setName(this.getName());
        s.setSurname(this.getSurname());
        s.setOfficerPosition(this.officerPosition);
        if (this.getContactInfo() != null) {
            s.setContactInfo(this.getContactInfo().getSchemaType());
        }
        return s;
    }

    void setSchemaType(OfficerStructure s) {
        this.setName(s.getName());
        this.setSurname(s.getSurname());
        this.officerPosition = s.getOfficerPosition();
        if (s.getContactInfo() != null) {
            ContactInfo info = new ContactInfo();
            info.setSchemaType(s.getContactInfo());
            this.setContactInfo(info);
        }
    }
}

