/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ContentReferenceStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.FileStructure;
import org.w3._2000._09.xmldsig.DigestMethodType;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.Utils;
import vraa.div.client.mailbox.FileReceiveContent;

public class MessageFile {
    private Integer appendixNumber;
    private String contentReference;
    private String digestMethod;
    private String digestValue;
    private Boolean enableCompression;
    private String mimeType;
    private String name;
    private Long fileSize;
    private boolean compressed;
    private byte[] contentBuffer;
    private InputStream contentStream;
    private FileReceiveContent contentReceive;

    public MessageFile() {
    }

    public MessageFile(byte[] content, String name) {
        if (content == null) {
            throw ExceptionBuilder.ArgumentNull("content");
        }
        this.setContent(content);
        this.name = name;
    }

    public MessageFile(InputStream inputStream, String name) {
        if (inputStream == null) {
            throw ExceptionBuilder.ArgumentNull("inputStream");
        }
        this.setContent(inputStream);
        this.name = name;
    }

    public void setAppendixNumber(Integer appendixNumber) {
        this.appendixNumber = appendixNumber;
    }

    public Integer getAppendixNumber() {
        return this.appendixNumber;
    }

    public String getContentReference() {
        return this.contentReference;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public String getDigestValue() {
        return this.digestValue;
    }

    public void setEnableCompression(Boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public Boolean getEnableCompression() {
        return this.enableCompression;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = Utils.ClientTrim(mimeType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setName(String name) {
        this.name = Utils.ClientTrim(name);
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        if (this.contentBuffer != null) {
            return this.contentBuffer.length;
        }
        if (this.contentStream != null) {
            try {
                if (this.contentStream instanceof FileInputStream) {
                    return ((FileInputStream)this.contentStream).getChannel().size();
                }
                if (this.contentStream instanceof ByteArrayInputStream) {
                    return this.contentStream.available();
                }
                if (this.contentStream.markSupported()) {
                    this.contentStream.mark(Integer.MAX_VALUE);
                    long res = this.contentStream.skip(Long.MAX_VALUE);
                    this.contentStream.reset();
                    return res;
                }
                throw new UnsupportedOperationException("stream length");
            }
            catch (IOException ioe) {
                throw new UnsupportedOperationException("stream length");
            }
        }
        if (this.fileSize != null) {
            return this.fileSize;
        }
        return 0L;
    }

    private void setSize(long value) {
        this.fileSize = value;
    }

    public void setContentReference(String contentReference) {
        this.contentReference = Utils.ClientTrim(contentReference);
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = Utils.ClientTrim(digestMethod);
    }

    public void setDigestValue(String digestValue) {
        this.digestValue = Utils.ClientTrim(digestValue);
    }

    public void setContent(byte[] content) {
        if (content == null) {
            throw ExceptionBuilder.ArgumentNull("content");
        }
        this.contentBuffer = content;
        this.contentStream = null;
        this.contentReceive = null;
    }

    public void setContent(InputStream stream) {
        if (stream == null) {
            throw ExceptionBuilder.ArgumentNull("stream");
        }
        this.contentBuffer = null;
        this.contentStream = stream;
        this.contentReceive = null;
    }

    public void setContent(FileReceiveContent receiveContent) {
        if (receiveContent == null) {
            throw ExceptionBuilder.ArgumentNull("receiveContent");
        }
        this.contentBuffer = null;
        this.contentStream = null;
        this.contentReceive = receiveContent;
    }

    FileStructure getSchemaType() {
        FileStructure file = new FileStructure();
        file.setMimeType(this.mimeType);
        file.setSize(BigInteger.valueOf(this.getSize()));
        file.setName(this.name);
        if (this.appendixNumber != null) {
            file.setAppendixNumber(this.appendixNumber);
        }
        file.setContent(new ContentReferenceStructure());
        file.getContent().setContentReference(this.contentReference);
        if (this.digestMethod != null) {
            file.getContent().setDigestMethod(new DigestMethodType());
            file.getContent().getDigestMethod().setAlgorithm(this.digestMethod);
        }
        if (this.digestValue != null) {
            file.getContent().setDigestValue(DatatypeConverter.parseBase64Binary((String)this.digestValue));
        }
        file.setCompressed(this.compressed);
        return file;
    }

    void setSchemaType(FileStructure file) {
        this.mimeType = file.getMimeType();
        this.setSize(file.getSize().longValue());
        this.name = file.getName();
        this.compressed = file.isCompressed();
        if (file.getAppendixNumber() != null) {
            this.appendixNumber = file.getAppendixNumber();
        }
        if (file.getContent() != null) {
            this.contentReference = file.getContent().getContentReference();
            if (file.getContent().getDigestValue() != null) {
                this.digestValue = DatatypeConverter.printBase64Binary((byte[])file.getContent().getDigestValue());
            }
            if (file.getContent().getDigestMethod() != null) {
                this.digestMethod = file.getContent().getDigestMethod().getAlgorithm();
            }
        }
    }

    public byte[] getContentBuffer() {
        return this.contentBuffer;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public FileReceiveContent getContentReceive() {
        return this.contentReceive;
    }
}

