/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EvenlyBufferedOutputStream
extends BufferedOutputStream {
    public EvenlyBufferedOutputStream(OutputStream outputStream, int i) {
        super(outputStream, i);
    }

    public EvenlyBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        int remLen = len;
        int currOff = off;
        int currRem = this.buf.length - this.count;
        while (remLen > currRem) {
            System.arraycopy(b, currOff, this.buf, this.count, currRem);
            remLen -= currRem;
            currOff += currRem;
            this.count += currRem;
            this.flushBuffer();
            currRem = this.buf.length;
        }
        if (remLen > 0) {
            System.arraycopy(b, currOff, this.buf, this.count, remLen);
            this.count += remLen;
        }
    }
}

