/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.AppendixEntryStructure;
import vraa.div.client.Correspondent;
import vraa.div.client.Utils;

public class DocumentAppendix {
    private Correspondent author;
    private XMLGregorianCalendar date;
    private int number;
    private String registrationNumber;
    private String title;

    public DocumentAppendix() {
    }

    public DocumentAppendix(int number, String title) {
        this.number = number;
        this.title = Utils.ClientTrim(title);
    }

    public void setAuthor(Correspondent author) {
        this.author = author;
    }

    public Correspondent getAuthor() {
        return this.author;
    }

    public void setDate(Date date) {
        this.date = Utils.dateToXML(date);
    }

    public Date getDate() {
        return Utils.XMLToDate(this.date);
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = Utils.ClientTrim(registrationNumber);
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setTitle(String title) {
        this.title = Utils.ClientTrim(title);
    }

    public String getTitle() {
        return this.title;
    }

    AppendixEntryStructure getSchemaType() {
        AppendixEntryStructure s = new AppendixEntryStructure();
        s.setAppendixNumber(this.number);
        s.setAppendixTitle(this.title);
        if (this.author != null) {
            s.setAppendixAuthor(this.author.getSchemaType());
        }
        s.setAppendixRegistrationNumber(this.registrationNumber);
        if (this.date != null) {
            s.setDate(this.date);
        }
        return s;
    }

    void setSchemaType(AppendixEntryStructure s) {
        this.number = s.getAppendixNumber();
        this.title = s.getAppendixTitle();
        if (s.getAppendixAuthor() != null) {
            this.author = new Correspondent(s.getAppendixAuthor());
        }
        this.registrationNumber = s.getAppendixRegistrationNumber();
        if (s.getDate() != null) {
            this.date = s.getDate();
        }
    }
}

