/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.net.URI;
import java.net.URISyntaxException;
import lv.gov.eps.ivis.xmlschemas._100001.address.v1_1.ICodeStructure;
import vraa.div.client.ClassifierMetadata;
import vraa.div.client.Utils;

public class Code {
    private ClassifierMetadata classifier;
    private String value;

    public Code() {
        this.classifier = new ClassifierMetadata();
    }

    public Code(String value) {
        this.value = Utils.ClientTrim(value);
        this.classifier = new ClassifierMetadata();
    }

    public void setClassifier(ClassifierMetadata classifier) {
        this.classifier = classifier;
    }

    public ClassifierMetadata getClassifier() {
        return this.classifier;
    }

    public void setValue(String value) {
        this.value = Utils.ClientTrim(value);
    }

    public String getValue() {
        return this.value;
    }

    void toSchemaItem(ICodeStructure item) {
        item.setCodeListName(this.classifier.getName());
        item.setCodeListID(this.classifier.getId());
        item.setCodeListAgencyID(this.classifier.getAgencyId());
        item.setCodeListAgencyName(this.classifier.getAgencyName());
        item.setCodeListVersionID(this.classifier.getVersionId());
        if (this.classifier.getListURI() != null) {
            item.setCodeListURI(this.classifier.getListURI().toString());
        }
        if (this.classifier.getSchemeURI() != null) {
            item.setCodeListSchemeURI(this.classifier.getSchemeURI().toString());
        }
        item.setCodeListLanguageID(this.classifier.getLanguageId());
        item.setCodeListCodeValue(this.classifier.getCodeValue());
        item.setValue(this.value);
    }

    void fromSchemaItem(ICodeStructure item) {
        if (this.classifier == null) {
            this.classifier = new ClassifierMetadata();
        }
        this.classifier.setName(item.getCodeListName());
        this.classifier.setId(item.getCodeListID());
        this.classifier.setAgencyId(item.getCodeListAgencyID());
        this.classifier.setAgencyName(item.getCodeListAgencyName());
        this.classifier.setVersionId(item.getCodeListVersionID());
        if (item.getCodeListURI() != null) {
            try {
                this.classifier.setListURI(new URI(item.getCodeListURI()));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (item.getCodeListSchemeURI() != null) {
            try {
                this.classifier.setSchemeURI(new URI(item.getCodeListSchemeURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.classifier.setLanguageId(item.getCodeListLanguageID());
        this.classifier.setCodeValue(item.getCodeListCodeValue());
        this.value = item.getValue();
    }
}

