/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml.XAdES;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import net.java.xades.security.xml.XAdES.SigningCertificate;
import net.java.xades.util.Base64;

public class SigningCertificateImpl
implements SigningCertificate {
    private X509Certificate certificate;
    private String digestMethod;

    public SigningCertificateImpl(X509Certificate certificate, String digestMethod) {
        this.certificate = certificate;
        this.digestMethod = digestMethod;
    }

    @Override
    public String getDigestMethodAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    @Override
    public String getDigestValue() throws GeneralSecurityException {
        String result;
        try {
            String algorithm = "SHA-1";
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(this.certificate.getEncoded());
            result = Base64.encodeBytes(md.digest());
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
        return result;
    }

    @Override
    public String getIssuerName() {
        return this.certificate.getIssuerDN().getName();
    }

    @Override
    public BigInteger getX509SerialNumber() {
        return this.certificate.getSerialNumber();
    }
}

