/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class X509IssuerSerialStrategy
extends KeyInfoStrategy {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    X509Certificate cert = null;
    String alias = null;

    public X509IssuerSerialStrategy() {
    }

    public X509IssuerSerialStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.cert = null;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(secureMsg.getSOAPPart(), this.cert);
        tokenRef.setReference(x509IssuerSerial);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial(ownerDoc, this.cert);
        tokenRef.setReference(x509IssuerSerial);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }
}

