/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.EncryptedKeySHA1Identifier;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.SamlKeyIdentifier;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.core.reference.X509ThumbPrintIdentifier;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class KeyIdentifierStrategy
extends KeyInfoStrategy {
    public static final int THUMBPRINT = 0;
    public static final int ENCRYPTEDKEYSHA1 = 1;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;
    boolean thumbprint;
    boolean encryptedKey = false;
    String samlAssertionId = null;

    public KeyIdentifierStrategy() {
    }

    public KeyIdentifierStrategy(int value) {
        if (value == 0) {
            this.thumbprint = true;
        } else if (value == 1) {
            this.encryptedKey = true;
        }
    }

    public KeyIdentifierStrategy(String samlAssertionId) {
        this.samlAssertionId = samlAssertionId;
        this.forSigning = false;
    }

    public KeyIdentifierStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
    }

    public KeyIdentifierStrategy(String alias, boolean forSigning, boolean thumbprint) {
        this.alias = alias;
        this.forSigning = forSigning;
        this.thumbprint = thumbprint;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0701_CANNOT_LOCATE_CERTIFICATE(this.alias), this.alias);
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + this.alias + "'");
        }
        tokenRef.setReference(keyIdentifier);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = this.getKeyIdentifier(secureMsg);
        if (keyIdentifier == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0701_CANNOT_LOCATE_CERTIFICATE(this.alias), this.alias);
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + this.alias + "'");
        }
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        tokenRef.setReference(keyIdentifier);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    private KeyIdentifier getKeyIdentifier(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        KeyIdentifier keyIdentifier = null;
        if (this.samlAssertionId != null) {
            keyIdentifier = new SamlKeyIdentifier(secureMsg.getSOAPPart());
            keyIdentifier.setReferenceValue(this.samlAssertionId);
            return keyIdentifier;
        }
        if (this.cert != null) {
            if (!this.thumbprint) {
                byte[] subjectKeyIdentifier = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(this.cert);
                if (subjectKeyIdentifier == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0702_NO_SUBJECT_KEYIDENTIFIER(this.alias), this.alias);
                    throw new XWSSecurityException("The found certificate does not contain subject key identifier X509 extension");
                }
                String keyId = Base64.encode(subjectKeyIdentifier);
                keyIdentifier = new X509SubjectKeyIdentifier(secureMsg.getSOAPPart());
                keyIdentifier.setReferenceValue(keyId);
            } else {
                byte[] thumbPrintIdentifier = X509ThumbPrintIdentifier.getThumbPrintIdentifier(this.cert);
                if (thumbPrintIdentifier == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0702_NO_SUBJECT_KEYIDENTIFIER(this.alias), this.alias);
                    throw new XWSSecurityException("Error while calculating thumb print identifier");
                }
                String keyId = Base64.encode(thumbPrintIdentifier);
                keyIdentifier = new X509ThumbPrintIdentifier(secureMsg.getSOAPPart());
                keyIdentifier.setReferenceValue(keyId);
            }
        } else if (this.encryptedKey) {
            keyIdentifier = new EncryptedKeySHA1Identifier(secureMsg.getSOAPPart());
        }
        return keyIdentifier;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }
}

