/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.testing;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.testing.PacketFilter;
import com.sun.xml.ws.rx.testing.PacketFilteringFeature;
import com.sun.xml.ws.rx.util.Communicator;
import java.io.IOException;
import java.util.List;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PacketFilteringTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(PacketFilteringTube.class);
    private final boolean isClientSide;
    private final RuntimeContext rc;
    private final List<PacketFilter> filters;

    public PacketFilteringTube(PacketFilteringTube original, TubeCloner cloner) {
        super(original, cloner);
        this.isClientSide = original.isClientSide;
        this.rc = original.rc;
        this.filters = original.filters;
    }

    public PacketFilteringTube(RmConfiguration configuration, Tube tubelineHead, ClientTubelineAssemblyContext context) {
        super(tubelineHead);
        this.isClientSide = true;
        RuntimeContext.Builder rcBuilder = RuntimeContext.builder(configuration, Communicator.builder("packet-filtering-client-tube-communicator").tubelineHead(this.next).addressingVersion(configuration.getAddressingVersion()).soapVersion(configuration.getSoapVersion()).jaxbContext(configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion())).build());
        this.rc = rcBuilder.build();
        this.filters = this.getConfiguredFilters(context.getBinding(), this.rc);
    }

    public PacketFilteringTube(RmConfiguration configuration, Tube tubelineHead, ServerTubelineAssemblyContext context) {
        super(tubelineHead);
        this.isClientSide = false;
        RuntimeContext.Builder rcBuilder = RuntimeContext.builder(configuration, Communicator.builder("packet-filtering-server-tube-communicator").tubelineHead(this.next).addressingVersion(configuration.getAddressingVersion()).soapVersion(configuration.getSoapVersion()).jaxbContext(configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion())).build());
        this.rc = rcBuilder.build();
        this.filters = this.getConfiguredFilters(context.getEndpoint().getBinding(), this.rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketFilteringTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            PacketFilteringTube packetFilteringTube = new PacketFilteringTube(this, cloner);
            return packetFilteringTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public void preDestroy() {
        this.rc.close();
        super.preDestroy();
    }

    @Override
    public NextAction processRequest(Packet request) {
        if (this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (request != null) {
                        request = filter.filterClientRequest(request);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException(ex));
            }
            if (request == null) {
                return this.doThrow(new WebServiceException(new IOException("Simulated IO error while sending a request")));
            }
        }
        return super.processRequest(request);
    }

    @Override
    public NextAction processResponse(Packet response) {
        if (!this.isClientSide) {
            try {
                for (PacketFilter filter : this.filters) {
                    if (response != null) {
                        response = filter.filterServerResponse(response);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.logSevereException(ex);
                if (ex instanceof RuntimeException) {
                    return this.doThrow(ex);
                }
                return this.doThrow(new WebServiceException(ex));
            }
        }
        return super.processResponse(response);
    }

    private List<PacketFilter> getConfiguredFilters(WSBinding binding, RuntimeContext context) {
        PacketFilteringFeature pfFeature = binding.getFeature(PacketFilteringFeature.class);
        return pfFeature.createFilters(context);
    }
}

