/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ConfirmationEntryStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.EAddressesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.EnvelopeStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.RecipientConfirmationPartStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.RecipientConfirmationStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.RecipientConfirmationsStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.SignatureStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.SignaturesStructure;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfAttachmentInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfAttachmentOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfRecipientPublicKey;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AttachmentInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AttachmentOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.CompleteSendMessageInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ConfirmMessageInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetPublicKeyListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetPublicKeyListOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.InitSendMessageInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.InitSendMessageOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ObjectFactory;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.RecipientPublicKey;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.SendMessageInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.SendMessageOutput;
import org.w3._2000._09.xmldsig.SignatureType;
import org.w3c.dom.Element;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.IntegrationMessage;
import vraa.div.client.MessageFile;
import vraa.div.client.MessageFileCollection;
import vraa.div.client.MessageRecipient;
import vraa.div.client.MessageRecipientConfirmationInfo;
import vraa.div.client.Utils;
import vraa.div.client.configuration.InternalCertificate;
import vraa.div.client.configuration.InternalFileType;
import vraa.div.client.mailbox.FileDecryptInfo;
import vraa.div.client.mailbox.FileDecryptor;
import vraa.div.client.mailbox.FileReceiveContent;
import vraa.div.client.mailbox.FileTransformHelper;
import vraa.div.client.mailbox.LargeFileSendOutputStream;
import vraa.div.client.mailbox.MessageFileInputStream;
import vraa.div.client.mailbox.OutgoingMessageFile;
import vraa.div.client.mailbox.RecipientEncryptionInfo;
import vraa.div.common.Envelope;
import vraa.div.common.SignatureConfiguration;
import vraa.div.common.XadesManager;

public class MessagingClient {
    public static final int MAX_MESSAGE_FILES_SIZE = 0x400000;
    private IntegrationClientContext context;

    private IntegrationClientContext getContext() {
        return this.context;
    }

    public MessagingClient(IntegrationClientContext context) {
        this.context = context;
    }

    public String send(IntegrationMessage message) {
        String serverId;
        List messageAttachments;
        String srsEaddresse;
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        MessagingClient.validateMessageForSending(message);
        if (message.getDocument().getKind().getCode().equals("EINVOICE") && (srsEaddresse = this.context.getConfiguration().getSrsEinvoiceEaddresse()) != null && !srsEaddresse.trim().isEmpty()) {
            boolean matchFound = false;
            for (MessageRecipient r : message.getRecipients()) {
                if (!r.getEAddress().equals(srsEaddresse)) continue;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                message.getRecipients().add(srsEaddresse);
            }
        }
        if (message.getDocument().getFiles().size() > 0) {
            this.prepareMessageFiles(message);
            ProcessMessageFilesOutput out = this.processMessageFiles(message);
            messageAttachments = out.attachments;
            serverId = out.serverId;
        } else {
            messageAttachments = new ArrayList();
            serverId = null;
        }
        EnvelopeStructure envelope = this.getSignedEnvelope(message);
        if (messageAttachments != null) {
            SendMessageInput sendRequest = new SendMessageInput();
            sendRequest.setEnvelope(envelope);
            if (messageAttachments.size() > 0) {
                ObjectFactory of = new ObjectFactory();
                ArrayOfAttachmentInput aai = of.createArrayOfAttachmentInput();
                aai.getAttachmentInput().addAll(messageAttachments);
                sendRequest.setAttachmentsInput(of.createSendMessageInputAttachmentsInput(aai));
            }
            SendMessageOutput resp = this.context.dispatchSendMessage(sendRequest);
            serverId = (String)resp.getMessageId().getValue();
        } else {
            CompleteSendMessageInput completeRequest = new CompleteSendMessageInput();
            ObjectFactory of = new ObjectFactory();
            completeRequest.setMessageId(of.createCompleteSendMessageInputMessageId(serverId));
            completeRequest.setEnvelope(envelope);
            this.context.dispatchCompleteSendMessage(completeRequest);
        }
        return serverId;
    }

    public IntegrationMessage get(String serverId) {
        GetMessageInput getRequest = new GetMessageInput();
        ObjectFactory of = new ObjectFactory();
        getRequest.setMessageId(of.createGetMessageInputMessageId(serverId));
        GetMessageOutput getResponse = this.context.call().getMessage(getRequest);
        IntegrationMessage message = null;
        if (getResponse != null && getResponse.getEnvelope() != null && getResponse.getEnvelope().getSenderDocument() != null) {
            EnvelopeStructure envelope = getResponse.getEnvelope();
            message = new IntegrationMessage();
            message.setSchemaType(envelope);
            MessageRecipientConfirmationInfo confirmInfo = new MessageRecipientConfirmationInfo();
            confirmInfo.getRelatedRecipients().addAll(((ArrayOfstring)getResponse.getRecipients().getValue()).getString());
            confirmInfo.setConfirmationName((String)getResponse.getConfirmationName().getValue());
            message.setConfirmationInfo(confirmInfo);
            HashMap<String, AttachmentOutput> fileDic = new HashMap<String, AttachmentOutput>();
            if (getResponse.getAttachmentsOutput() != null) {
                for (AttachmentOutput f : ((ArrayOfAttachmentOutput)getResponse.getAttachmentsOutput().getValue()).getAttachmentOutput()) {
                    fileDic.put(((String)f.getContentId().getValue()).toLowerCase(), f);
                }
            }
            FileDecryptInfo decryptInfo = null;
            if (message.getDocument().getFiles().size() > 0) {
                decryptInfo = new FileDecryptInfo(message);
            }
            for (MessageFile file : message.getDocument().getFiles()) {
                FileReceiveContent receiveContent;
                if (!fileDic.containsKey(file.getContentReference())) {
                    throw ExceptionBuilder.Technical("incomingFileInformationNotCorrect", new Object[0]);
                }
                AttachmentOutput incomingFile = (AttachmentOutput)fileDic.get(file.getContentReference().toLowerCase());
                if (incomingFile.isIsSeparateCall().booleanValue()) {
                    if (incomingFile.getSectionCount().isNil()) {
                        throw ExceptionBuilder.Technical("incomingFileInformationNotCorrect", new Object[0]);
                    }
                    receiveContent = new FileReceiveContent(decryptInfo, message.getMessageId(), (String)incomingFile.getContentId().getValue(), (Long)incomingFile.getSectionCount().getValue());
                    file.setContent(receiveContent);
                    continue;
                }
                if (incomingFile.getContents() == null || incomingFile.getContents().getValue() == null || ((byte[])incomingFile.getContents().getValue()).length == 0) {
                    throw ExceptionBuilder.Technical("incomingFileEmpty", new Object[0]);
                }
                receiveContent = new FileReceiveContent(decryptInfo, (byte[])incomingFile.getContents().getValue());
                file.setContent(receiveContent);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFileContent(MessageFile messageFile, OutputStream destination, FileDecryptor preparedDecryptor) {
        boolean releaseDecryptor;
        FileDecryptor decryptor;
        if (messageFile == null) {
            throw ExceptionBuilder.ArgumentNull("messageFile");
        }
        if (destination == null) {
            throw ExceptionBuilder.ArgumentNull("destination");
        }
        this.validateMessageFile(messageFile);
        if (preparedDecryptor != null) {
            decryptor = preparedDecryptor;
            releaseDecryptor = false;
        } else {
            decryptor = messageFile.getContentReceive() != null ? FileDecryptor.createFromInfo(messageFile.getContentReceive().getDecryptInfo()) : FileDecryptor.createEmpty();
            releaseDecryptor = true;
        }
        try {
            MessageFileInputStream inputStream = new MessageFileInputStream(messageFile, this.context);
            String hash = FileTransformHelper.receive(inputStream, destination, decryptor.getCipher(this.context), messageFile.isCompressed());
            if (!hash.equals(messageFile.getDigestValue())) {
                throw ExceptionBuilder.Client("BL.BIB.027", new Object[0]);
            }
        }
        finally {
            if (releaseDecryptor) {
                decryptor = null;
            }
        }
    }

    private void validateMessageFile(MessageFile messageFile) {
        if (!"http://www.w3.org/2001/04/xmlenc#sha512".equals(messageFile.getDigestMethod())) {
            throw ExceptionBuilder.Client("BL.BIB.021", new Object[0]);
        }
        if (Utils.isNullOrEmpty(messageFile.getDigestValue())) {
            throw ExceptionBuilder.Client("BL.BIB.022", new Object[0]);
        }
        if ((messageFile.getContentBuffer() == null || messageFile.getContentBuffer().length == 0) && messageFile.getContentStream() == null && messageFile.getContentReceive() == null) {
            throw ExceptionBuilder.Client("BL.BIB.024", new Object[0]);
        }
    }

    public void confirm(IntegrationMessage message, boolean accept, String code, String text) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        if (message.getConfirmationInfo() == null) {
            throw ExceptionBuilder.Client("BL.BIB.028", new Object[0]);
        }
        RecipientConfirmationPartStructure recipientConfirmation = new RecipientConfirmationPartStructure();
        ConfirmationEntryStructure confirmationData = new ConfirmationEntryStructure();
        String confirmationName = message.getConfirmationInfo().getConfirmationName();
        confirmationData.setId(Envelope.getRecipientSectionId(confirmationName));
        confirmationData.setStatus(accept ? "RecipientAccepted" : "RecipientRejected");
        confirmationData.setStatusCode(code);
        confirmationData.setStatusReason(text);
        EAddressesStructure eas = new EAddressesStructure();
        eas.getEAddress().addAll(message.getConfirmationInfo().getRelatedRecipients());
        confirmationData.setRelatedRecipients(eas);
        recipientConfirmation.setRecipientConfirmations(new RecipientConfirmationStructure());
        recipientConfirmation.getRecipientConfirmations().setConfirmationEntry(confirmationData);
        RecipientConfirmationsStructure rs = new RecipientConfirmationsStructure();
        RecipientConfirmationsStructure confirmations = message.getSchemaType().getRecipientConfirmations();
        if (confirmations != null) {
            rs.getConfirmationEntry().addAll(confirmations.getConfirmationEntry());
        }
        rs.getConfirmationEntry().add(recipientConfirmation.getRecipientConfirmations().getConfirmationEntry());
        Element confirmXml = Envelope.serialize(new QName("http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0", "RecipientConfirmationPart"), RecipientConfirmationPartStructure.class, recipientConfirmation);
        Element confirmedMessageXml = Envelope.combineEnvelopeParts("RecipientConfirmationPart", new Element[]{message.getXml(), confirmXml});
        confirmedMessageXml = Utils.netify(confirmedMessageXml);
        Element signature = this.signXml(confirmedMessageXml, Envelope.getRecipientSignatureId(confirmationName), new String[]{"SenderSection", "ServerSection", Envelope.getRecipientSectionId(confirmationName)});
        SignatureType confirmSignature = Envelope.deserialize(SignatureType.class, signature);
        recipientConfirmation.setSignatures(new SignatureStructure());
        recipientConfirmation.getSignatures().setSignature(confirmSignature);
        ConfirmMessageInput request = new ConfirmMessageInput();
        ObjectFactory of = new ObjectFactory();
        request.setMessageId(of.createConfirmMessageInputMessageId(message.getMessageId()));
        request.setRecipientConfirmationPart(recipientConfirmation);
        try {
            this.context.dispatchConfirmMessage(request);
        }
        catch (Exception ex) {
            if (this.isLogEnabled()) {
                String newLine = System.getProperty("line.separator");
                StringBuilder source = new StringBuilder();
                source.append("[ MessageId ]" + newLine);
                source.append(message.getMessageId() + newLine);
                source.append(newLine);
                source.append("[ ErrorText ]" + newLine);
                source.append(ex.getMessage() + newLine);
                source.append(newLine);
                source.append("[ Message.Xml ]" + newLine);
                source.append(message.getXmlString() + newLine);
                source.append(newLine);
                source.append("[ ConfirmedMessageXml ]" + newLine);
                source.append(Utils.xmlToString(confirmedMessageXml) + newLine);
                source.append(newLine);
                source.append("[ Signature ]" + newLine);
                source.append(Utils.xmlToString(signature) + newLine);
                source.append(newLine);
                source.append("[ RecipientConfirmation ]" + newLine);
                source.append(Utils.xmlToString(confirmXml) + newLine);
                this.Log("Confirm-" + this.getLogTime() + "-" + message.getMessageId() + ".log", source.toString());
            }
            throw new RuntimeException(ex);
        }
    }

    private String getLogTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMddHHmmss");
        return format1.format(cal.getTime());
    }

    private boolean isLogEnabled() {
        return !Utils.isNullOrEmpty(this.context.getConfiguration().getLogPath());
    }

    private void Log(String filename, String source) {
        if (this.isLogEnabled()) {
            String file = this.context.getConfiguration().getLogPath() + File.separator + filename;
            try {
                File newTextFile = new File(file);
                FileWriter fw = new FileWriter(newTextFile);
                fw.write(source);
                fw.close();
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
        }
    }

    private static void validateMessageForSending(IntegrationMessage message) {
        int i;
        if (message.getRecipients().size() == 0) {
            throw ExceptionBuilder.Client("BL.BIB.017", new Object[0]);
        }
        for (i = 0; i < message.getRecipients().size(); ++i) {
            MessageRecipient recipient = (MessageRecipient)message.getRecipients().get(i);
            if (recipient.getEAddress() != null && !recipient.getEAddress().trim().isEmpty()) continue;
            throw ExceptionBuilder.Client("BL.BIB.018", i);
        }
        for (i = 0; i < message.getDocument().getFiles().size(); ++i) {
            boolean valid = false;
            MessageFile file = (MessageFile)message.getDocument().getFiles().get(i);
            if (file.getContentBuffer() != null) {
                valid = file.getContentBuffer().length > 0;
            } else if (file.getContentStream() != null) {
                valid = true;
            }
            if (valid) continue;
            throw ExceptionBuilder.Client("BL.BIB.019", i);
        }
    }

    private boolean getMessageEncryptionSetting(IntegrationMessage message) {
        boolean encrypt = false;
        if (message.getDocument().getFiles().size() > 0) {
            encrypt = message.getEnableEncryption() != null ? message.getEnableEncryption().booleanValue() : this.context.getConfiguration().getEncryptByDefault();
        }
        return encrypt;
    }

    private void prepareMessageFiles(IntegrationMessage message) {
        for (int i = 0; i < message.getDocument().getFiles().size(); ++i) {
            MessageFile file = (MessageFile)message.getDocument().getFiles().get(i);
            file.setContentReference(String.valueOf(i));
            InternalFileType fileType = null;
            String extension = null;
            if (!Utils.isNullOrEmpty(file.getName())) {
                extension = Utils.getExtension(file.getName());
            }
            if (!Utils.isNullOrEmpty(extension)) {
                extension = extension.toLowerCase();
                if (this.context.getConfiguration().getFileTypes().containsKey(extension)) {
                    fileType = this.context.getConfiguration().getFileTypes().get(extension);
                }
            }
            if (file.getEnableCompression() != null) {
                file.setCompressed(file.getEnableCompression());
            } else if (fileType != null && fileType.getCompress() != null) {
                file.setCompressed(fileType.getCompress());
            } else {
                file.setCompressed(this.context.getConfiguration().getCompressByDefault());
            }
            if (!Utils.isNullOrEmpty(file.getMimeType())) continue;
            if (fileType != null && !Utils.isNullOrEmpty(fileType.getMimeType())) {
                file.setMimeType(fileType.getMimeType());
                continue;
            }
            file.setMimeType("application/octet-stream");
        }
    }

    private ProcessMessageFilesOutput processMessageFiles(IntegrationMessage message) {
        ArrayList<OutgoingMessageFile> files = new ArrayList<OutgoingMessageFile>();
        ArrayList<OutgoingMessageFile> filesWithMessage = new ArrayList<OutgoingMessageFile>();
        ArrayList<Object> filesSeparate = new ArrayList<Object>();
        long currentSize = 0L;
        MessageFileCollection filesBySize = (MessageFileCollection)message.getDocument().getFiles().clone();
        Collections.sort(filesBySize, new Comparator<MessageFile>(){

            @Override
            public int compare(MessageFile o1, MessageFile o2) {
                return Long.valueOf(o1.getSize()).compareTo(o2.getSize());
            }
        });
        for (MessageFile file : filesBySize) {
            OutgoingMessageFile outMsg = new OutgoingMessageFile();
            outMsg.setFile(file);
            files.add(outMsg);
            if (currentSize + file.getSize() <= 0x400000L) {
                outMsg.setWithMessage(true);
                filesWithMessage.add(outMsg);
            } else {
                filesSeparate.add(outMsg);
            }
            currentSize += file.getSize();
        }
        boolean encryptFiles = this.getMessageEncryptionSetting(message);
        ArrayList<AttachmentInput> attachments = null;
        String serverId = null;
        Cipher cipher = null;
        try {
            Object file;
            if (encryptFiles) {
                List<RecipientEncryptionInfo> recipientEncryption = this.getRecipientEncryptionInfo(message);
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(256);
                SecretKey skey = kgen.generateKey();
                cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(1, skey);
                MessagingClient.encryptKeyForRecipients(message, recipientEncryption, skey.getEncoded(), cipher.getIV());
            }
            for (OutgoingMessageFile outFile : filesWithMessage) {
                file = outFile.getFile();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                MessageFileInputStream messageFileInputStream = new MessageFileInputStream((MessageFile)file, this.context);
                String string = FileTransformHelper.send(messageFileInputStream, byteArrayOutputStream, cipher, ((MessageFile)file).isCompressed());
                ((MessageFile)file).setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
                ((MessageFile)file).setDigestValue(string);
                outFile.setOutputContentBuffer(byteArrayOutputStream.toByteArray());
            }
            long withMessageSize = 0L;
            for (OutgoingMessageFile outgoingMessageFile : filesWithMessage) {
                withMessageSize += (long)outgoingMessageFile.getOutputContentBuffer().length;
            }
            if (withMessageSize > 0x400000L) {
                Collections.sort(filesWithMessage, new Comparator<OutgoingMessageFile>(){

                    @Override
                    public int compare(OutgoingMessageFile o1, OutgoingMessageFile o2) {
                        return Integer.valueOf(o1.getOutputContentBuffer().length).compareTo(o2.getOutputContentBuffer().length);
                    }
                });
            }
            while (withMessageSize > 0x400000L && filesWithMessage.size() > 0) {
                file = (OutgoingMessageFile)filesWithMessage.get(filesWithMessage.size() - 1);
                ((OutgoingMessageFile)file).setWithMessage(false);
                filesWithMessage.remove(filesWithMessage.size() - 1);
                filesSeparate.add(file);
                withMessageSize -= (long)((OutgoingMessageFile)file).getOutputContentBuffer().length;
            }
            ArrayList<AttachmentInput> filesInputWithMessage = new ArrayList<AttachmentInput>();
            for (OutgoingMessageFile outgoingMessageFile : filesWithMessage) {
                AttachmentInput attachmentInput = new AttachmentInput();
                ObjectFactory of = new ObjectFactory();
                attachmentInput.setContentId(of.createAttachmentInputContentId(outgoingMessageFile.getFile().getContentReference()));
                attachmentInput.setContents(of.createAttachmentInputContents(new DataHandler((DataSource)outgoingMessageFile)));
                filesInputWithMessage.add(attachmentInput);
            }
            if (filesSeparate.size() > 0) {
                ArrayList<AttachmentInput> arrayList = new ArrayList<AttachmentInput>();
                for (OutgoingMessageFile outgoingMessageFile : filesSeparate) {
                    AttachmentInput ai = new AttachmentInput();
                    ObjectFactory of = new ObjectFactory();
                    ai.setContentId(of.createAttachmentInputContentId(outgoingMessageFile.getFile().getContentReference()));
                    arrayList.add(ai);
                }
                InitSendMessageInput initSendMessageInput = new InitSendMessageInput();
                ObjectFactory objectFactory = new ObjectFactory();
                initSendMessageInput.setMessageClientId(objectFactory.createInitSendMessageInputMessageClientId(message.getClientId()));
                initSendMessageInput.setSenderEAddress(objectFactory.createInitSendMessageInputSenderEAddress(message.getFrom()));
                ArrayOfAttachmentInput aai = objectFactory.createArrayOfAttachmentInput();
                List<AttachmentInput> aail = aai.getAttachmentInput();
                aail.addAll(filesInputWithMessage);
                aail.addAll(arrayList);
                initSendMessageInput.setAttachmentsInput(objectFactory.createInitSendMessageInputAttachmentsInput(aai));
                InitSendMessageOutput initResponse = this.context.call().initSendMessage(initSendMessageInput);
                for (OutgoingMessageFile outgoingMessageFile : filesSeparate) {
                    MessageFile file2 = outgoingMessageFile.getFile();
                    LargeFileSendOutputStream outStream = new LargeFileSendOutputStream((String)initResponse.getMessageId().getValue(), file2.getContentReference(), this.context);
                    if (outgoingMessageFile.getOutputContentBuffer() != null) {
                        int read;
                        byte[] buffer = new byte[4096];
                        ByteArrayInputStream memStream = new ByteArrayInputStream(outgoingMessageFile.getOutputContentBuffer());
                        while ((read = memStream.read(buffer, 0, buffer.length)) > 0) {
                            ((OutputStream)outStream).write(buffer, 0, read);
                        }
                        ((OutputStream)outStream).close();
                        memStream.close();
                        continue;
                    }
                    MessageFileInputStream inputStream = new MessageFileInputStream(file2, this.context);
                    String hash = FileTransformHelper.send(inputStream, outStream, cipher, file2.isCompressed());
                    file2.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
                    file2.setDigestValue(hash);
                }
                serverId = (String)initResponse.getMessageId().getValue();
            } else {
                attachments = filesInputWithMessage;
            }
            return new ProcessMessageFilesOutput(attachments, serverId);
        }
        catch (IOException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
    }

    private List<RecipientEncryptionInfo> getRecipientEncryptionInfo(IntegrationMessage message) {
        ArrayList<RecipientEncryptionInfo> result = new ArrayList<RecipientEncryptionInfo>();
        GetPublicKeyListInput getPublicRequest = new GetPublicKeyListInput();
        ObjectFactory of = new ObjectFactory();
        ArrayOfstring as = new ArrayOfstring();
        for (MessageRecipient r : message.getRecipients()) {
            as.getString().add(r.getEAddress());
        }
        getPublicRequest.setRecipients(of.createGetPublicKeyListInputRecipients(as));
        GetPublicKeyListOutput getPublicResponse = this.context.call().getPublicKeyList(getPublicRequest);
        HashMap<Object, RecipientPublicKey> publicKeyDic = new HashMap<Object, RecipientPublicKey>();
        for (RecipientPublicKey p : ((ArrayOfRecipientPublicKey)getPublicResponse.getPublicKeys().getValue()).getRecipientPublicKey()) {
            publicKeyDic.put(p.getEAddress().getValue(), p);
        }
        for (MessageRecipient recipient : message.getRecipients()) {
            if (!publicKeyDic.containsKey(recipient.getEAddress())) {
                throw ExceptionBuilder.Client("BL.BIB.020", recipient.getEAddress());
            }
            RecipientPublicKey recipientPublicKey = (RecipientPublicKey)publicKeyDic.get(recipient.getEAddress());
            String modVal = (String)recipientPublicKey.getModulus().getValue();
            byte[] modByte = DatatypeConverter.parseBase64Binary((String)modVal);
            BigInteger modulus = new BigInteger(1, modByte);
            byte[] expByte = DatatypeConverter.parseBase64Binary((String)((String)recipientPublicKey.getExponent().getValue()));
            BigInteger exponent = new BigInteger(1, expByte);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
            recipient.setCertificateThumbprint((String)recipientPublicKey.getCertificateThumbprint().getValue());
            RecipientEncryptionInfo recipientEncrypt = new RecipientEncryptionInfo();
            recipientEncrypt.setRecipient(recipient);
            recipientEncrypt.setPublicKeySpec(publicKeySpec);
            result.add(recipientEncrypt);
        }
        return result;
    }

    private static void encryptKeyForRecipients(IntegrationMessage message, List<RecipientEncryptionInfo> recipients, byte[] key, byte[] iv) {
        byte[] symmetricKey = new byte[1 + key.length + iv.length];
        try {
            symmetricKey[0] = (byte)key.length;
            System.arraycopy(key, 0, symmetricKey, 1, key.length);
            System.arraycopy(iv, 0, symmetricKey, key.length + 1, iv.length);
            for (int i = 0; i < recipients.size(); ++i) {
                RecipientEncryptionInfo recipientEncryption = recipients.get(i);
                if (!Utils.isNullOrEmpty(recipientEncryption.getRecipient().getEncryptedKey())) continue;
                KeyFactory fact = KeyFactory.getInstance("RSA");
                PublicKey pubKey = fact.generatePublic(recipientEncryption.getPublicKeySpec());
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                cipher.init(1, pubKey);
                byte[] encryptedKey = cipher.doFinal(symmetricKey);
                recipientEncryption.getRecipient().setEncryptedKey(DatatypeConverter.printBase64Binary((byte[])encryptedKey));
                for (int j = i + 1; j < recipients.size(); ++j) {
                    RecipientEncryptionInfo otherRecipient = recipients.get(j);
                    if (!recipientEncryption.getRecipient().getCertificateThumbprint().equals(otherRecipient.getRecipient().getCertificateThumbprint())) continue;
                    otherRecipient.getRecipient().setEncryptedKey(recipientEncryption.getRecipient().getEncryptedKey());
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
        finally {
            Arrays.fill(symmetricKey, (byte)0);
        }
    }

    private EnvelopeStructure getSignedEnvelope(IntegrationMessage message) {
        Element document = message.getXml();
        document.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0");
        Element signature = this.signXml(document, "SenderSignature", new String[]{"SenderSection"});
        EnvelopeStructure envelope = message.getSchemaType();
        SignaturesStructure ss = new SignaturesStructure();
        SignatureType senderSignature = Envelope.deserialize(SignatureType.class, signature);
        ss.getSignature().add(senderSignature);
        envelope.setSignatures(ss);
        message.addSignature(senderSignature);
        return envelope;
    }

    private Element signXml(Element xml, String signatureId, String[] signedSectionIds) {
        InternalCertificate cert = this.getContext().getConfiguration().getDefaultCertificate();
        XadesManager signatureManager = new XadesManager();
        SignatureConfiguration signatureConfig = new SignatureConfiguration();
        signatureConfig.setEntry(cert.getEntry());
        signatureConfig.setTsaAddress(null);
        return signatureManager.createSignature(xml, signatureConfig, signatureId, signedSectionIds);
    }

    private static final class ProcessMessageFilesOutput {
        private List<AttachmentInput> attachments;
        private String serverId;

        private ProcessMessageFilesOutput(List<AttachmentInput> attachments, String serverId) {
            this.attachments = attachments;
            this.serverId = serverId;
        }
    }
}

