/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Utils {
    public static List<KeyStore.Entry> findByThumbprint(KeyStore keystore, String thumbprint, char[] password) {
        ArrayList<KeyStore.Entry> res = new ArrayList<KeyStore.Entry>();
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                KeyStore.PasswordProtection pp = null;
                if (password != null) {
                    pp = new KeyStore.PasswordProtection(password);
                }
                KeyStore.Entry entry = keystore.getEntry(alias, pp);
                X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
                if (!thumbprint.equals(Utils.getThumbPrint(cert))) continue;
                res.add(entry);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return res;
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return Utils.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public static XMLGregorianCalendar dateToXML(Date date) {
        if (date == null) {
            return null;
        }
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            XMLGregorianCalendar c = datatypeFactory.newXMLGregorianCalendar(cal);
            c.setTimezone(Integer.MIN_VALUE);
            return c;
        }
        catch (DatatypeConfigurationException dce) {
            throw new RuntimeException(dce);
        }
    }

    public static XMLGregorianCalendar dateOnlyToXML(Date date) {
        if (date == null) {
            return null;
        }
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal0 = new GregorianCalendar();
            cal0.setTime(date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.set(cal0.get(1), cal0.get(2), cal0.get(5), 0, 0, 0);
            XMLGregorianCalendar c = datatypeFactory.newXMLGregorianCalendar(cal);
            c.setTimezone(Integer.MIN_VALUE);
            return c;
        }
        catch (DatatypeConfigurationException dce) {
            throw new RuntimeException(dce);
        }
    }

    public static Date XMLToDate(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.toGregorianCalendar().getTime();
    }

    public static void copyPipe(InputStream in, OutputStream out) throws IOException {
        int read = -1;
        byte[] buf = new byte[8192];
        while ((read = in.read(buf, 0, 8192)) >= 0) {
            out.write(buf, 0, read);
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int ind = path.lastIndexOf(46);
        if (ind == -1) {
            return "";
        }
        return path.substring(ind + 1);
    }

    public static void printXML(Object o) {
        System.out.println();
        try {
            JAXB.marshal((Object)o, (OutputStream)System.out);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        System.out.println();
    }

    public static void printDOM(Element sign, OutputStream os) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(sign);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new RuntimeException(tfce);
        }
    }

    public static void printDOM(Element sign) {
        System.out.println();
        Utils.printDOM(sign, System.out);
        System.out.println();
    }

    public static String xmlToString(Element dom) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(dom);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Element stringToXml(String xmlStr) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(xmlStr)));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Element netify(Element sign) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer(new StreamSource(Utils.class.getClassLoader().getResourceAsStream("resources/xml.netify.xsl")));
            DOMSource source = new DOMSource(sign);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Element xml = ((Document)result.getNode()).getDocumentElement();
            return xml;
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new RuntimeException(tfce);
        }
    }

    public static <E> Collection<E> makeCollection(Iterable<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iter) {
            list.add(item);
        }
        return list;
    }

    public static String ClientTrim(String value) {
        return value != null ? value.trim() : null;
    }
}

