/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.CorrespondentStructure;
import vraa.div.client.BaseCollection;
import vraa.div.client.Correspondent;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.InformationSystem;
import vraa.div.client.InformationSystemCollection;
import vraa.div.client.Institution;
import vraa.div.client.InstitutionCollection;
import vraa.div.client.PrivatePerson;
import vraa.div.client.PrivatePersonCollection;

public class CorrespondentCollection
extends BaseCollection<Correspondent> {
    public Institution addInstitution(String title) {
        Institution institution = new Institution(title);
        this.add(new Correspondent(institution));
        return institution;
    }

    public void addInstitution(Institution institution) {
        if (institution == null) {
            throw ExceptionBuilder.ArgumentNull("institution");
        }
        this.add(new Correspondent(institution));
    }

    public PrivatePerson addPrivatePerson(String name, String surname) {
        PrivatePerson person = new PrivatePerson(name, surname);
        this.add(new Correspondent(person));
        return person;
    }

    public void addPrivatePerson(PrivatePerson privatePerson) {
        if (privatePerson == null) {
            throw ExceptionBuilder.ArgumentNull("privatePerson");
        }
        this.add(new Correspondent(privatePerson));
    }

    public void addInformationSystem(InformationSystem informationSystem) {
        if (informationSystem == null) {
            throw ExceptionBuilder.ArgumentNull("informationSystem");
        }
        this.add(new Correspondent(informationSystem));
    }

    public InstitutionCollection getInstitutions() {
        return new InstitutionCollection(){

            @Override
            public int size() {
                int res = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution()) continue;
                    ++res;
                }
                return res;
            }

            @Override
            public boolean isEmpty() {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean contains(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution() || !corr.getInstitutionData().equals(o)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Institution> iterator() {
                return new Iterator<Institution>(){
                    private int cursor;
                    private int lastRet = -1;

                    @Override
                    public boolean hasNext() {
                        while (this.cursor < CorrespondentCollection.this.size()) {
                            if (((Correspondent)CorrespondentCollection.this.get(this.cursor)).isInstitution()) {
                                return true;
                            }
                            ++this.cursor;
                        }
                        return false;
                    }

                    @Override
                    public Institution next() {
                        if (this.hasNext()) {
                            this.lastRet = this.cursor;
                            return ((Correspondent)CorrespondentCollection.this.get(this.cursor++)).getInstitutionData();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.lastRet == -1) {
                            throw new IllegalStateException();
                        }
                        CorrespondentCollection.this.remove(this.lastRet);
                        this.lastRet = -1;
                        --this.cursor;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] res = new Object[this.size()];
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution()) continue;
                    res[ind++] = corr.getInstitutionData();
                }
                return res;
            }

            @Override
            public Object[] toArray(Object[] a) {
                if (a.length < this.size()) {
                    a = new Object[this.size()];
                }
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution()) continue;
                    a[ind++] = corr.getInstitutionData();
                }
                return a;
            }

            @Override
            public boolean add(Institution e) {
                CorrespondentCollection.this.addInstitution(e);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInstitution() || !corr.getInstitutionData().equals(o)) continue;
                    CorrespondentCollection.this.remove(corr);
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object x : c) {
                    if (this.contains(x)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Institution> c) {
                boolean res = false;
                for (Institution institution : c) {
                    this.add(institution);
                    res = true;
                }
                return res;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean res = false;
                Iterator<Institution> iit = this.iterator();
                while (iit.hasNext()) {
                    if (!c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean res = false;
                Iterator<Institution> iit = this.iterator();
                while (iit.hasNext()) {
                    if (c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public void clear() {
                Iterator<Institution> iit = this.iterator();
                while (iit.hasNext()) {
                    iit.next();
                    iit.remove();
                }
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }
        };
    }

    public PrivatePersonCollection getPrivatePersons() {
        return new PrivatePersonCollection(){

            @Override
            public int size() {
                int res = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson()) continue;
                    ++res;
                }
                return res;
            }

            @Override
            public boolean isEmpty() {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean contains(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson() || !corr.getPrivatePersonData().equals(o)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<PrivatePerson> iterator() {
                return new Iterator<PrivatePerson>(){
                    private int cursor;
                    private int lastRet = -1;

                    @Override
                    public boolean hasNext() {
                        while (this.cursor < CorrespondentCollection.this.size()) {
                            if (((Correspondent)CorrespondentCollection.this.get(this.cursor)).isPrivatePerson()) {
                                return true;
                            }
                            ++this.cursor;
                        }
                        return false;
                    }

                    @Override
                    public PrivatePerson next() {
                        if (this.hasNext()) {
                            this.lastRet = this.cursor;
                            return ((Correspondent)CorrespondentCollection.this.get(this.cursor++)).getPrivatePersonData();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.lastRet == -1) {
                            throw new IllegalStateException();
                        }
                        CorrespondentCollection.this.remove(this.lastRet);
                        this.lastRet = -1;
                        --this.cursor;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] res = new Object[this.size()];
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson()) continue;
                    res[ind++] = corr.getPrivatePersonData();
                }
                return res;
            }

            @Override
            public Object[] toArray(Object[] a) {
                if (a.length < this.size()) {
                    a = new Object[this.size()];
                }
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson()) continue;
                    a[ind++] = corr.getPrivatePersonData();
                }
                return a;
            }

            @Override
            public boolean add(PrivatePerson e) {
                CorrespondentCollection.this.addPrivatePerson(e);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isPrivatePerson() || !corr.getPrivatePersonData().equals(o)) continue;
                    CorrespondentCollection.this.remove(corr);
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object x : c) {
                    if (this.contains(x)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends PrivatePerson> c) {
                boolean res = false;
                for (PrivatePerson privatePerson : c) {
                    this.add(privatePerson);
                    res = true;
                }
                return res;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean res = false;
                Iterator<PrivatePerson> iit = this.iterator();
                while (iit.hasNext()) {
                    if (!c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean res = false;
                Iterator<PrivatePerson> iit = this.iterator();
                while (iit.hasNext()) {
                    if (c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public void clear() {
                Iterator<PrivatePerson> iit = this.iterator();
                while (iit.hasNext()) {
                    iit.next();
                    iit.remove();
                }
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }
        };
    }

    public InformationSystemCollection getInformationSystems() {
        return new InformationSystemCollection(){

            @Override
            public int size() {
                int res = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem()) continue;
                    ++res;
                }
                return res;
            }

            @Override
            public boolean isEmpty() {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean contains(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem() || !corr.getInformationSystemData().equals(o)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<InformationSystem> iterator() {
                return new Iterator<InformationSystem>(){
                    private int cursor;
                    private int lastRet = -1;

                    @Override
                    public boolean hasNext() {
                        while (this.cursor < CorrespondentCollection.this.size()) {
                            if (((Correspondent)CorrespondentCollection.this.get(this.cursor)).isInformationSystem()) {
                                return true;
                            }
                            ++this.cursor;
                        }
                        return false;
                    }

                    @Override
                    public InformationSystem next() {
                        if (this.hasNext()) {
                            this.lastRet = this.cursor;
                            return ((Correspondent)CorrespondentCollection.this.get(this.cursor++)).getInformationSystemData();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.lastRet == -1) {
                            throw new IllegalStateException();
                        }
                        CorrespondentCollection.this.remove(this.lastRet);
                        this.lastRet = -1;
                        --this.cursor;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] res = new Object[this.size()];
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem()) continue;
                    res[ind++] = corr.getInformationSystemData();
                }
                return res;
            }

            @Override
            public Object[] toArray(Object[] a) {
                if (a.length < this.size()) {
                    a = new Object[this.size()];
                }
                int ind = 0;
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem()) continue;
                    a[ind++] = corr.getInformationSystemData();
                }
                return a;
            }

            @Override
            public boolean add(InformationSystem e) {
                CorrespondentCollection.this.addInformationSystem(e);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                for (Correspondent corr : CorrespondentCollection.this) {
                    if (!corr.isInformationSystem() || !corr.getInformationSystemData().equals(o)) continue;
                    CorrespondentCollection.this.remove(corr);
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object x : c) {
                    if (this.contains(x)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends InformationSystem> c) {
                boolean res = false;
                for (InformationSystem informationSystem : c) {
                    this.add(informationSystem);
                    res = true;
                }
                return res;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean res = false;
                Iterator<InformationSystem> iit = this.iterator();
                while (iit.hasNext()) {
                    if (!c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean res = false;
                Iterator<InformationSystem> iit = this.iterator();
                while (iit.hasNext()) {
                    if (c.contains(iit.next())) continue;
                    iit.remove();
                    res = true;
                }
                return res;
            }

            @Override
            public void clear() {
                Iterator<InformationSystem> iit = this.iterator();
                while (iit.hasNext()) {
                    iit.next();
                    iit.remove();
                }
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }
        };
    }

    List<CorrespondentStructure> getSchemaType() {
        ArrayList<CorrespondentStructure> result = new ArrayList<CorrespondentStructure>();
        if (this.size() > 0) {
            for (Correspondent c : this) {
                result.add(c.getSchemaType());
            }
        }
        return result;
    }

    void setSchemaType(List<CorrespondentStructure> value) {
        if (value != null) {
            for (CorrespondentStructure schemaItem : value) {
                Correspondent corr = new Correspondent(schemaItem);
                this.add(corr);
            }
        }
    }
}

