/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import vraa.div.client.BaseCollection;
import vraa.div.client.ClientCertificateReferenceCollection;
import vraa.div.client.FileTypeConfiguration;

@XmlRootElement(name="div.client")
@XmlType(propOrder={"serviceAddress", "compressByDefault", "encryptByDefault", "logPath", "srsEinvoiceEaddresse", "autoValidate", "timeout", "certificates", "fileTypes"})
public class ClientConfiguration {
    public static final String SNAME = "div.client";
    private static final Logger log = Logger.getLogger(ClientConfiguration.class.getName());
    private boolean autoValidate;
    private ClientCertificateReferenceCollection certificates = new ClientCertificateReferenceCollection();
    private boolean compressByDefault = true;
    private boolean encryptByDefault = true;
    private BaseCollection<FileTypeConfiguration> fileTypes = new BaseCollection();
    private String serviceAddress = "https://vraa.gov.lv/Vraa.Div.WebService.UnifiedInterface/UnifiedService.svc";
    private int timeout = 10;
    private String logPath;
    private String srsEinvoiceEaddresse;

    public static ClientConfiguration fromConfig(String sectionName, String fileName) {
        try {
            if (sectionName == null || sectionName.isEmpty()) {
                sectionName = SNAME;
            }
            if (fileName == null || fileName.isEmpty()) {
                fileName = "app.config";
            }
            if (log.isLoggable(Level.INFO)) {
                log.info(String.format("sectionName='%s', fileName='%s'", sectionName, fileName));
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientConfiguration.class});
            Unmarshaller u = jc.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(fileName));
            Node node = doc.getElementsByTagName(sectionName).item(0);
            if (!sectionName.equals(SNAME)) {
                node = doc.renameNode(node, null, SNAME);
            }
            return (ClientConfiguration)u.unmarshal(node);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "nevar nolas\u012bt konfigur\u0101ciju", e);
            }
            return new ClientConfiguration();
        }
    }

    public String toXml() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientConfiguration.class});
            Marshaller m = jc.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            m.marshal((Object)this, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (JAXBException jaxbe) {
            throw new RuntimeException(jaxbe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void setAutoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
    }

    @XmlElement(name="autoValidate")
    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    @XmlElementWrapper(name="certificates")
    @XmlElement(name="certificate")
    public ClientCertificateReferenceCollection getCertificates() {
        return this.certificates;
    }

    public void setCompressByDefault(boolean compressByDefault) {
        this.compressByDefault = compressByDefault;
    }

    @XmlElement(name="compressByDefault")
    public boolean isCompressByDefault() {
        return this.compressByDefault;
    }

    public void setEncryptByDefault(boolean encryptByDefault) {
        this.encryptByDefault = encryptByDefault;
    }

    @XmlElement(name="encryptByDefault")
    public boolean isEncryptByDefault() {
        return this.encryptByDefault;
    }

    @XmlElementWrapper(name="fileTypes")
    @XmlElement(name="fileType")
    public List<FileTypeConfiguration> getFileTypes() {
        return this.fileTypes;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    @XmlElement(name="serviceAddress")
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @XmlElement(name="timeout")
    public int getTimeout() {
        return this.timeout;
    }

    @XmlElement(name="logPath")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @XmlElement(name="srsEinvoiceEaddresse")
    public String getSrsEinvoiceEaddresse() {
        return this.srsEinvoiceEaddresse;
    }

    public void setSrsEinvoiceEaddresse(String srsEinvoiceEaddresse) {
        this.srsEinvoiceEaddresse = srsEinvoiceEaddresse;
    }
}

