/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml.XAdES;

import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import net.java.xades.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAdESStructure
extends DOMStructure {
    public static final String SIGNATURE_ELEMENT_NAME = "Signature";
    public static final String ID_ATTRIBUTE = "Id";
    public static final String TARGET_ATTRIBUTE = "Target";
    private Document baseDocument;
    public String xadesPrefix;
    public String xadesNamespace;
    public String xmlSignaturePrefix;

    public XAdESStructure(Document document, XAdESStructure parent, String elementName, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        this(document, parent.getElement(), elementName, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public XAdESStructure(Document document, Element parentElement, String elementName, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        this(document.createElementNS(xadesNamespace, elementName), xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        this.baseDocument = document;
        this.xadesPrefix = xadesPrefix;
        this.xadesNamespace = xadesNamespace;
        this.xmlSignaturePrefix = xmlSignaturePrefix;
        Element element = this.getElement();
        parentElement.appendChild(element);
    }

    public XAdESStructure(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node);
        this.xadesPrefix = xadesPrefix;
        this.xadesNamespace = xadesNamespace;
        this.xmlSignaturePrefix = xmlSignaturePrefix;
    }

    public Element getElement() {
        return (Element)this.getNode();
    }

    public String getId() {
        return this.getAttribute(ID_ATTRIBUTE);
    }

    protected void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.getElement().setAttributeNS(namespaceURI, qualifiedName, value);
        if (ID_ATTRIBUTE.equals(qualifiedName)) {
            this.getElement().setIdAttributeNS(null, ID_ATTRIBUTE, true);
        }
    }

    protected String getAttribute(String name) {
        return this.getElement().getAttribute(name);
    }

    protected String getAttributeNS(String namespaceURI, String qualifiedName) {
        return this.getElement().getAttributeNS(namespaceURI, qualifiedName);
    }

    protected String getTextContent() {
        return this.getElement().getTextContent();
    }

    protected void setTextContent(String textContent) {
        this.getElement().setTextContent(textContent);
    }

    protected Element getChildElement(String elementName) {
        return XMLUtils.getChildElementByTagName(this.getElement(), elementName);
    }

    protected Element getChildElementNS(String elementName) {
        return XMLUtils.getChildElementByTagNameNS(this.getElement(), elementName, this.xadesNamespace);
    }

    protected Element getChildElementNS(String elementName, String namespace) {
        return XMLUtils.getChildElementByTagNameNS(this.getElement(), elementName, namespace);
    }

    protected List<Element> getChildElements(String elementName) {
        return XMLUtils.getChildElementsByTagName(this.getElement(), elementName);
    }

    protected List<Element> getChildElementsNS(String elementName) {
        return XMLUtils.getChildElementsByTagNameNS(this.getElement(), elementName, this.xadesNamespace);
    }

    protected Document getDocument() {
        return this.baseDocument;
    }

    protected Element createElement(String elementName) {
        Element element = this.getDocument().createElementNS(this.xadesNamespace, elementName);
        return element;
    }

    protected Element createElementNS(String namespace, String prefix, String elementName) {
        Element element = this.getDocument().createElementNS(namespace, elementName);
        element.setPrefix(prefix);
        return element;
    }

    protected String getChildElementTextContent(String elementName) {
        Element element = this.getChildElementNS(elementName);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }
}

