/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.security.core.xenc.CVAdapter;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext11.EncryptedHeaderType;
import com.sun.xml.ws.security.secext11.ObjectFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.Data;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedHeader
implements SecurityHeaderElement,
SecurityElementWriter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private EncryptedHeaderType eht = null;
    private boolean isCanonicalized = false;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private Data data = null;
    private Key key = null;
    private CryptoProcessor dep = null;

    public EncryptedHeader(EncryptedHeaderType eht, Data data, Key key, SOAPVersion soapVersion) {
        this.eht = eht;
        this.key = key;
        this.data = data;
        this.soapVersion = soapVersion;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        SecurityElement se;
        Object data;
        List<Object> list;
        KeyInfo ki = (KeyInfo)this.eht.getEncryptedData().getKeyInfo();
        if (ki != null && (list = ki.getContent()).size() > 0 && (data = list.get(0)) instanceof SecurityHeaderElement) {
            return ((SecurityHeaderElement)data).refersToSecHdrWithId(id);
        }
        if (this.data instanceof SSEData && (se = ((SSEData)this.data).getSecurityElement()) instanceof SecurityHeaderElement) {
            return ((SecurityHeaderElement)se).refersToSecHdrWithId(id);
        }
        return false;
    }

    @Override
    public String getId() {
        return this.eht.getId();
    }

    @Override
    public void setId(String id) {
        this.eht.setId(id);
    }

    @Override
    public String getNamespaceURI() {
        return "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    }

    @Override
    public String getLocalPart() {
        return "EncryptedHeader";
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public byte[] canonicalize(String algorithm, List<AttributeNS> namespaceDecls) {
        throw new UnsupportedOperationException();
    }

    public boolean isCanonicalized() {
        return this.isCanonicalized;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        try {
            OutputStream os;
            if (streamWriter instanceof Map && this.dep == null && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.writeTo(os);
                return;
            }
            Marshaller writer = this.getMarshaller();
            if (this.dep == null) {
                this.dep = new CryptoProcessor(1, this.eht.getEncryptedData().getEncryptionMethod().getAlgorithm(), this.data, this.key);
                if (streamWriter instanceof StAXEXC14nCanonicalizerImpl) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        this.dep.encryptData(bos);
                    }
                    catch (IOException ie) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1920_ERROR_CALCULATING_CIPHERVALUE(), ie);
                        throw new XMLStreamException("Error occurred while calculating Cipher Value");
                    }
                    this.dep.setEncryptedDataCV(bos.toByteArray());
                }
            }
            CVAdapter adapter = new CVAdapter(this.dep);
            writer.setAdapter(CVAdapter.class, adapter);
            ObjectFactory obj = new ObjectFactory();
            JAXBElement<EncryptedHeaderType> eh = obj.createEncryptedHeader(this.eht);
            writer.marshal(eh, streamWriter);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1916_ERROR_WRITING_ECRYPTEDHEADER(ex.getMessage()), ex);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1916_ERROR_WRITING_ECRYPTEDHEADER(ex.getMessage()), ex);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1916_ERROR_WRITING_ECRYPTEDHEADER(jbe.getMessage()), jbe);
            throw new XMLStreamException(jbe);
        }
    }

    @Override
    public void writeTo(OutputStream os) {
        try {
            Marshaller writer = this.getMarshaller();
            CryptoProcessor dep = new CryptoProcessor(1, this.eht.getEncryptedData().getEncryptionMethod().getAlgorithm(), this.data, this.key);
            CVAdapter adapter = new CVAdapter(dep);
            writer.setAdapter(CVAdapter.class, adapter);
            ObjectFactory obj = new ObjectFactory();
            JAXBElement<EncryptedHeaderType> eh = obj.createEncryptedHeader(this.eht);
            writer.marshal(eh, os);
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1916_ERROR_WRITING_ECRYPTEDHEADER(ex.getMessage()), ex);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1916_ERROR_WRITING_ECRYPTEDHEADER(ex.getMessage()), ex);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }
}

