/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.addressing.WsaTubeHelper;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.DistributedPropertySet;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.DispatchException;
import com.sun.xml.ws.wsdl.OperationDispatcher;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.jvnet.ws.message.MessageContext;
import org.jvnet.ws.message.PropertySet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Packet
extends DistributedPropertySet
implements MessageContext {
    private Message message;
    private QName wsdlOperation;
    public boolean wasTransportSecure;
    public static final String INBOUND_TRANSPORT_HEADERS = "com.sun.xml.ws.api.message.packet.inbound.transport.headers";
    public static final String OUTBOUND_TRANSPORT_HEADERS = "com.sun.xml.ws.api.message.packet.outbound.transport.headers";
    public static final String HA_INFO = "com.sun.xml.ws.api.message.packet.hainfo";
    @PropertySet.Property(value={"com.sun.xml.ws.handler.config"})
    public HandlerConfiguration handlerConfig;
    @PropertySet.Property(value={"com.sun.xml.ws.client.handle"})
    public BindingProvider proxy;
    public boolean isAdapterDeliversNonAnonymousResponse;
    public EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation;
    public String acceptableMimeTypes;
    public WebServiceContextDelegate webServiceContextDelegate;
    @Nullable
    public TransportBackChannel transportBackChannel;
    public Component component;
    @PropertySet.Property(value={"com.sun.xml.ws.api.server.WSEndpoint"})
    public WSEndpoint endpoint;
    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String soapAction;
    @PropertySet.Property(value={"com.sun.xml.ws.server.OneWayOperation"})
    public Boolean expectReply;
    @Deprecated
    public Boolean isOneWay;
    public Boolean isSynchronousMEP;
    public Boolean nonNullAsyncHandlerGiven;
    private Set<String> handlerScopePropertyNames;
    public final Map<String, Object> invocationProperties;
    private static final PropertySet.PropertyMap model = Packet.parse(Packet.class);
    private static final Logger LOGGER = Logger.getLogger(Packet.class.getName());

    public Packet(Message request) {
        this();
        this.message = request;
    }

    public Packet() {
        this.invocationProperties = new HashMap<String, Object>();
    }

    private Packet(Packet that) {
        that.copySatelliteInto(this);
        this.handlerConfig = that.handlerConfig;
        this.invocationProperties = that.invocationProperties;
        this.handlerScopePropertyNames = that.handlerScopePropertyNames;
        this.contentNegotiation = that.contentNegotiation;
        this.wasTransportSecure = that.wasTransportSecure;
        this.transportBackChannel = that.transportBackChannel;
        this.endpointAddress = that.endpointAddress;
        this.isAdapterDeliversNonAnonymousResponse = that.isAdapterDeliversNonAnonymousResponse;
        this.wsdlOperation = that.wsdlOperation;
        this.acceptableMimeTypes = that.acceptableMimeTypes;
        this.endpoint = that.endpoint;
        this.proxy = that.proxy;
        this.webServiceContextDelegate = that.webServiceContextDelegate;
        this.soapAction = that.soapAction;
        this.expectReply = that.expectReply;
        this.component = that.component;
    }

    public Packet copy(boolean copyMessage) {
        Packet copy = new Packet(this);
        if (copyMessage && this.message != null) {
            copy.message = this.message.copy();
        }
        return copy;
    }

    public Message getMessage() {
        return this.message;
    }

    public WSBinding getBinding() {
        if (this.endpoint != null) {
            return this.endpoint.getBinding();
        }
        if (this.proxy != null) {
            return (WSBinding)this.proxy.getBinding();
        }
        return null;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @PropertySet.Property(value={"javax.xml.ws.wsdl.operation"})
    @Nullable
    public final QName getWSDLOperation() {
        if (this.wsdlOperation != null) {
            return this.wsdlOperation;
        }
        OperationDispatcher opDispatcher = null;
        if (this.endpoint != null) {
            opDispatcher = ((WSEndpointImpl)this.endpoint).getOperationDispatcher();
        } else if (this.proxy != null) {
            opDispatcher = ((Stub)this.proxy).getOperationDispatcher();
        }
        if (opDispatcher != null) {
            try {
                this.wsdlOperation = opDispatcher.getWSDLOperationQName(this);
            }
            catch (DispatchException dispatchException) {
                // empty catch block
            }
        }
        return this.wsdlOperation;
    }

    public void setWSDLOperation(QName wsdlOp) {
        this.wsdlOperation = wsdlOp;
    }

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        if (this.endpointAddress == null) {
            return null;
        }
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String s) {
        this.endpointAddress = s == null ? null : EndpointAddress.create(s);
    }

    @PropertySet.Property(value={"com.sun.xml.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation != null ? this.contentNegotiation.toString() : null;
    }

    public void setContentNegotiationString(String s) {
        if (s == null) {
            this.contentNegotiation = null;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.reference.parameters"})
    @NotNull
    public List<Element> getReferenceParameters() {
        ArrayList<Element> refParams = new ArrayList<Element>();
        if (this.message == null) {
            return refParams;
        }
        HeaderList hl = this.message.getHeaders();
        for (Header h : hl) {
            String attr = h.getAttribute(AddressingVersion.W3C.nsUri, "IsReferenceParameter");
            if (attr == null || !attr.equals("true") && !attr.equals("1")) continue;
            Document d = DOMUtil.createDom();
            SAX2DOMEx s2d = new SAX2DOMEx(d);
            try {
                h.writeTo(s2d, XmlUtil.DRACONIAN_ERROR_HANDLER);
                refParams.add((Element)d.getLastChild());
            }
            catch (SAXException e) {
                throw new WebServiceException(e);
            }
        }
        return refParams;
    }

    @PropertySet.Property(value={"com.sun.xml.ws.api.message.HeaderList"})
    HeaderList getHeaderList() {
        if (this.message == null) {
            return null;
        }
        return this.message.getHeaders();
    }

    public TransportBackChannel keepTransportBackChannelOpen() {
        TransportBackChannel r = this.transportBackChannel;
        this.transportBackChannel = null;
        return r;
    }

    public final Set<String> getHandlerScopePropertyNames(boolean readOnly) {
        Set<String> o = this.handlerScopePropertyNames;
        if (o == null) {
            if (readOnly) {
                return Collections.emptySet();
            }
            this.handlerScopePropertyNames = o = new HashSet<String>();
        }
        return o;
    }

    public final Set<String> getApplicationScopePropertyNames(boolean readOnly) {
        assert (false);
        return new HashSet<String>();
    }

    @Deprecated
    public Packet createResponse(Message msg) {
        Packet response = new Packet(this);
        response.setMessage(msg);
        return response;
    }

    public Packet createClientResponse(Message msg) {
        Packet response = new Packet(this);
        response.soapAction = null;
        response.setMessage(msg);
        return response;
    }

    public Packet createServerResponse(@Nullable Message responseMessage, @Nullable WSDLPort wsdlPort, @Nullable SEIModel seiModel, @NotNull WSBinding binding) {
        Packet r = this.createClientResponse(responseMessage);
        AddressingVersion av = binding.getAddressingVersion();
        if (av == null) {
            return r;
        }
        String inputAction = this.getMessage().getHeaders().getAction(av, binding.getSOAPVersion());
        if (inputAction == null) {
            return r;
        }
        if (responseMessage == null || wsdlPort != null && this.message.isOneWay(wsdlPort)) {
            return r;
        }
        this.populateAddressingHeaders(binding, r, wsdlPort, seiModel);
        return r;
    }

    public Packet relateServerResponse(@Nullable Packet r, @Nullable WSDLPort wsdlPort, @Nullable SEIModel seiModel, @NotNull WSBinding binding) {
        this.copySatelliteInto(r);
        r.soapAction = null;
        r.handlerConfig = this.handlerConfig;
        r.invocationProperties.putAll(this.invocationProperties);
        r.handlerScopePropertyNames = this.handlerScopePropertyNames;
        r.contentNegotiation = this.contentNegotiation;
        r.wasTransportSecure = this.wasTransportSecure;
        r.endpointAddress = this.endpointAddress;
        r.wsdlOperation = this.wsdlOperation;
        r.acceptableMimeTypes = this.acceptableMimeTypes;
        r.endpoint = this.endpoint;
        r.proxy = this.proxy;
        r.webServiceContextDelegate = this.webServiceContextDelegate;
        r.expectReply = this.expectReply;
        AddressingVersion av = binding.getAddressingVersion();
        if (av == null) {
            return r;
        }
        String inputAction = this.getMessage().getHeaders().getAction(av, binding.getSOAPVersion());
        if (inputAction == null) {
            return r;
        }
        if (r.getMessage() == null || wsdlPort != null && this.message.isOneWay(wsdlPort)) {
            return r;
        }
        this.populateAddressingHeaders(binding, r, wsdlPort, seiModel);
        return r;
    }

    public Packet createServerResponse(@Nullable Message responseMessage, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion soapVersion, @NotNull String action) {
        Packet responsePacket = this.createClientResponse(responseMessage);
        if (addressingVersion == null) {
            return responsePacket;
        }
        String inputAction = this.getMessage().getHeaders().getAction(addressingVersion, soapVersion);
        if (inputAction == null) {
            return responsePacket;
        }
        this.populateAddressingHeaders(responsePacket, addressingVersion, soapVersion, action, false);
        return responsePacket;
    }

    public void setResponseMessage(@NotNull Packet request, @Nullable Message responseMessage, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion soapVersion, @NotNull String action) {
        Packet temp = request.createServerResponse(responseMessage, addressingVersion, soapVersion, action);
        this.setMessage(temp.getMessage());
    }

    private void populateAddressingHeaders(Packet responsePacket, AddressingVersion av, SOAPVersion sv, String action, boolean mustUnderstand) {
        if (av == null) {
            return;
        }
        if (responsePacket.getMessage() == null) {
            return;
        }
        HeaderList hl = responsePacket.getMessage().getHeaders();
        WsaPropertyBag wpb = this.getSatellite(WsaPropertyBag.class);
        WSEndpointReference replyTo = null;
        if (wpb != null) {
            replyTo = wpb.getReplyToFromRequest();
        }
        if (replyTo == null) {
            replyTo = this.message.getHeaders().getReplyTo(av, sv);
        }
        if (responsePacket.getMessage().getHeaders().getAction(av, sv) == null) {
            hl.add(new StringHeader(av.actionTag, action, sv, mustUnderstand));
        }
        if (responsePacket.getMessage().getHeaders().get(av.messageIDTag, false) == null) {
            String newID = Message.generateMessageID();
            hl.add(new StringHeader(av.messageIDTag, newID));
        }
        String mid = null;
        if (wpb != null) {
            mid = wpb.getMessageID();
        }
        if (mid == null) {
            mid = this.message.getHeaders().getMessageID(av, sv);
        }
        if (mid != null) {
            hl.add(new RelatesToHeader(av.relatesToTag, mid));
        }
        WSEndpointReference refpEPR = null;
        if (responsePacket.getMessage().isFault()) {
            if (wpb != null) {
                refpEPR = wpb.getFaultToFromRequest();
            }
            if (refpEPR == null) {
                refpEPR = this.message.getHeaders().getFaultTo(av, sv);
            }
            if (refpEPR == null) {
                refpEPR = replyTo;
            }
        } else {
            refpEPR = replyTo;
        }
        if (refpEPR != null) {
            hl.add(new StringHeader(av.toTag, refpEPR.getAddress()));
            refpEPR.addReferenceParametersToList(hl);
        }
    }

    private void populateAddressingHeaders(WSBinding binding, Packet responsePacket, WSDLPort wsdlPort, SEIModel seiModel) {
        String action;
        AddressingVersion addressingVersion = binding.getAddressingVersion();
        if (addressingVersion == null) {
            return;
        }
        WsaTubeHelper wsaHelper = addressingVersion.getWsaHelper(wsdlPort, seiModel, binding);
        String string2 = action = responsePacket.message.isFault() ? wsaHelper.getFaultAction(this, responsePacket) : wsaHelper.getOutputAction(this);
        if (action == null) {
            LOGGER.info("WSA headers are not added as value for wsa:Action cannot be resolved for this message");
            return;
        }
        this.populateAddressingHeaders(responsePacket, addressingVersion, binding.getSOAPVersion(), action, AddressingVersion.isRequired(binding));
    }

    public String toShortString() {
        return super.toString();
    }

    public String toString() {
        String content;
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        try {
            if (this.message != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter xmlWriter = XMLStreamWriterFactory.create(baos, "UTF-8");
                this.message.copy().writeTo(xmlWriter);
                xmlWriter.flush();
                xmlWriter.close();
                baos.flush();
                XMLStreamWriterFactory.recycle(xmlWriter);
                byte[] bytes = baos.toByteArray();
                content = new String(bytes, "UTF-8");
            } else {
                content = "<none>";
            }
        }
        catch (Throwable t) {
            throw new WebServiceException(t);
        }
        buf.append(" Content: ").append(content);
        return buf.toString();
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    @Override
    public SOAPMessage getSOAPMessage() throws SOAPException {
        return this.message != null ? this.message.readAsSOAPMessage() : null;
    }
}

