/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ModelWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class CanonicalModelWriter
extends ModelWriter
implements ProcessorAction,
SOAPTypeVisitor,
LiteralTypeVisitor {
    public CanonicalModelWriter(IndentingWriter w) {
        super(w);
    }

    public CanonicalModelWriter(OutputStream out) {
        super(out);
    }

    public CanonicalModelWriter(File f) throws FileNotFoundException {
        this(new FileOutputStream(f));
    }

    public void visit(Model model) throws Exception {
        this.preVisit(model);
        TreeSet<Service> sortedServices = new TreeSet<Service>(new GetNameComparator(Service.class));
        Iterator iter = model.getServices();
        while (iter.hasNext()) {
            Service service = (Service)iter.next();
            sortedServices.add(service);
        }
        for (Service service : sortedServices) {
            this.preVisit(service);
            TreeSet<Port> sortedPorts = new TreeSet<Port>(new GetNameComparator(Port.class));
            Iterator iter2 = service.getPorts();
            while (iter2.hasNext()) {
                Port port = (Port)iter2.next();
                sortedPorts.add(port);
            }
            for (Port port : sortedPorts) {
                this.preVisit(port);
                TreeSet<Operation> sortedOperations = new TreeSet<Operation>(new GetNameComparator(Operation.class));
                Iterator iter3 = port.getOperations();
                while (iter3.hasNext()) {
                    Operation operation = (Operation)iter3.next();
                    sortedOperations.add(operation);
                }
                for (Operation operation : sortedOperations) {
                    Iterator iter4;
                    Block block3;
                    Iterator iter42;
                    this.preVisit(operation);
                    Request request = operation.getRequest();
                    if (request != null) {
                        this.preVisit(request);
                        TreeSet<Block> sortedHeaderBlocks = new TreeSet<Block>(new GetNameComparator(Block.class));
                        Iterator iter43 = request.getHeaderBlocks();
                        while (iter43.hasNext()) {
                            Block block2 = (Block)iter43.next();
                            sortedHeaderBlocks.add(block2);
                        }
                        for (Block block2 : sortedHeaderBlocks) {
                            this.visitHeaderBlock(block2);
                        }
                        TreeSet<Block> sortedBodyBlocks = new TreeSet<Block>(new GetNameComparator(Block.class));
                        iter42 = request.getBodyBlocks();
                        while (iter42.hasNext()) {
                            block3 = (Block)iter42.next();
                            sortedBodyBlocks.add(block3);
                        }
                        for (Block block3 : sortedBodyBlocks) {
                            this.visitBodyBlock(block3);
                        }
                        TreeSet<Parameter> sortedParams = new TreeSet<Parameter>(new GetNameComparator(Parameter.class));
                        iter4 = request.getParameters();
                        while (iter4.hasNext()) {
                            Parameter parameter = (Parameter)iter4.next();
                            sortedParams.add(parameter);
                        }
                        for (Parameter parameter : sortedParams) {
                            this.visit(parameter);
                        }
                        this.postVisit(request);
                    }
                    Response response = operation.getResponse();
                    if (request != null) {
                        this.preVisit(response);
                        TreeSet<Block> sortedHeaderBlocks = new TreeSet<Block>(new GetNameComparator(Block.class));
                        iter42 = response.getHeaderBlocks();
                        while (iter42.hasNext()) {
                            block3 = (Block)iter42.next();
                            sortedHeaderBlocks.add(block3);
                        }
                        for (Block block3 : sortedHeaderBlocks) {
                            this.visitHeaderBlock(block3);
                        }
                        TreeSet<Block> sortedBodyBlocks = new TreeSet<Block>(new GetNameComparator(Block.class));
                        iter4 = response.getBodyBlocks();
                        while (iter4.hasNext()) {
                            Block block4 = (Block)iter4.next();
                            sortedBodyBlocks.add(block4);
                        }
                        for (Block block4 : sortedBodyBlocks) {
                            this.visitBodyBlock(block4);
                        }
                        TreeSet<Parameter> sortedParams = new TreeSet<Parameter>(new GetNameComparator(Parameter.class));
                        Iterator iter44 = response.getParameters();
                        while (iter44.hasNext()) {
                            Parameter parameter = (Parameter)iter44.next();
                            sortedParams.add(parameter);
                        }
                        for (Parameter parameter : sortedParams) {
                            this.visit(parameter);
                        }
                        this.postVisit(response);
                    }
                    TreeSet<Fault> sortedFaults = new TreeSet<Fault>(new GetNameComparator(Operation.class));
                    iter42 = operation.getFaults();
                    while (iter42.hasNext()) {
                        Fault fault = (Fault)iter42.next();
                        sortedFaults.add(fault);
                    }
                    for (Fault fault : sortedFaults) {
                        this.preVisit(fault);
                        this.visitFaultBlock(fault.getBlock());
                        this.postVisit(fault);
                    }
                    this.postVisit(operation);
                }
                this.postVisit(port);
            }
            this.postVisit(service);
        }
        this.postVisit(model);
    }

    protected void processTypes(Model model) throws Exception {
        TreeSet<AbstractType> sortedTypes = new TreeSet<AbstractType>(new GetNameComparator(AbstractType.class));
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            AbstractType extraType = (AbstractType)iter.next();
            sortedTypes.add(extraType);
        }
        for (AbstractType extraType : sortedTypes) {
            if (extraType.isLiteralType()) {
                this.describe((LiteralType)extraType);
                continue;
            }
            if (!extraType.isSOAPType()) continue;
            this.describe((SOAPType)extraType);
        }
    }

    protected void processAttributeMembers(LiteralStructuredType type) throws Exception {
        TreeSet<LiteralAttributeMember> sortedAttMem = new TreeSet<LiteralAttributeMember>(new GetNameComparator(LiteralAttributeMember.class));
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
            sortedAttMem.add(attribute);
        }
        for (LiteralAttributeMember attribute : sortedAttMem) {
            this.writeAttributeMember(attribute);
        }
    }

    protected void processElementMembers(LiteralStructuredType type) throws Exception {
        TreeSet<LiteralElementMember> sortedElemMem = new TreeSet<LiteralElementMember>(new GetNameComparator(LiteralElementMember.class));
        Iterator iter = type.getElementMembers();
        while (iter.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)iter.next();
            sortedElemMem.add(element);
        }
        for (LiteralElementMember element : sortedElemMem) {
            this.writeElementMember(element);
        }
    }

    protected void processMembers(SOAPStructureType type) throws Exception {
        TreeSet<SOAPStructureMember> sortedMembers = new TreeSet<SOAPStructureMember>(new GetNameComparator(SOAPStructureMember.class));
        Iterator iter = type.getMembers();
        while (iter.hasNext()) {
            SOAPStructureMember member = (SOAPStructureMember)iter.next();
            sortedMembers.add(member);
        }
        for (SOAPStructureMember member : sortedMembers) {
            this.writeMember(member);
        }
    }

    public static int compareNames(Object o1, Object o2) {
        if (o1 instanceof QName) {
            return ((QName)o1).toString().compareTo(((QName)o2).toString());
        }
        return ((String)o1).compareTo((String)o2);
    }

    public static class GetNameComparator
    implements Comparator {
        private Method getNameMethod = null;

        public GetNameComparator(Class objClass) {
            try {
                Class[] argsClass = new Class[]{};
                this.getNameMethod = objClass.getMethod("getName", argsClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int compare(Object o1, Object o2) {
            try {
                Object[] args = new Object[]{};
                return CanonicalModelWriter.compareNames(this.getNameMethod.invoke(o1, args), this.getNameMethod.invoke(o2, args));
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

