/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.provider.wsit.PacketMapMessageInfo;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import com.sun.xml.wss.provider.wsit.PipeHelper;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSecurityTube
extends AbstractFilterTubeImpl {
    protected static final Logger logger = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private final boolean isHttpBinding;
    private PipeHelper helper;
    private AuthStatus status = AuthStatus.SEND_SUCCESS;
    private ServerAuthContext sAC = null;
    private PacketMessageInfo info = null;
    private WSEndpoint wsEndpoint = null;

    public ServerSecurityTube(Map<Object, Object> props, Tube next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", this);
        this.helper = new PipeHelper("SOAP", props, null);
        this.isHttpBinding = isHttpBinding;
        this.wsEndpoint = (WSEndpoint)props.get("ENDPOINT");
    }

    protected ServerSecurityTube(ServerSecurityTube that, TubeCloner cloner) {
        super(that, cloner);
        this.helper = that.helper;
        this.isHttpBinding = that.isHttpBinding;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ServerSecurityTube(this, cloner);
    }

    private Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = this.helper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }

    @Override
    public NextAction processRequest(Packet request) {
        this.info = new PacketMapMessageInfo(request, new Packet());
        Subject serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
        Packet validatedRequest = null;
        Subject clientSubject = this.getClientSubject(request);
        try {
            this.sAC = this.helper.getServerAuthContext(this.info, serverSubject);
            if (this.sAC != null) {
                this.status = this.sAC.validateRequest(this.info, clientSubject, serverSubject);
                validatedRequest = this.info.getRequestPacket();
            } else {
                validatedRequest = this.info.getRequestPacket();
                this.status = AuthStatus.SUCCESS;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0053_ERROR_VALIDATE_REQUEST(), e);
            WebServiceException wse = new WebServiceException("Cannot validate request for", e);
            this.status = AuthStatus.SEND_FAILURE;
            validatedRequest = this.helper.getFaultResponse(this.info.getRequestPacket(), this.info.getResponsePacket(), wse);
            return this.doReturnWith(validatedRequest);
        }
        if (this.status == AuthStatus.SUCCESS) {
            this.helper.authorize(validatedRequest);
            if (System.getSecurityManager() == null) {
                return this.doInvoke(this.next, validatedRequest);
            }
            final Tube nextTube = this.next;
            final Packet valRequest = validatedRequest;
            try {
                return (NextAction)Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ServerSecurityTube.this.doInvoke(nextTube, valRequest);
                    }
                }, null);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AuthException) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0055_WS_ERROR_NEXT_PIPE(), cause);
                }
                Packet response = this.helper.getFaultResponse(validatedRequest, this.info.getResponsePacket(), cause);
                return this.doReturnWith(response);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ws.status_validate_request", this.status);
        }
        Packet response = this.info.getResponsePacket();
        return this.doReturnWith(response);
    }

    @Override
    public NextAction processResponse(Packet response) {
        Subject serverSubject = (Subject)response.invocationProperties.get("SERVER_SUBJECT");
        if (this.sAC != null && response.getMessage() != null) {
            try {
                this.info.setResponsePacket(response);
                response = this.processResponse(this.info, this.sAC, serverSubject);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0057_ERROR_PROCESS_RESPONSE(), ex);
            }
        }
        return this.doReturnWith(response);
    }

    @Override
    public NextAction processException(Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        return this.doThrow(t);
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext sAC, Subject serverSubject) {
        try {
            AuthStatus stat = sAC.secureResponse(info, serverSubject);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ws.status_secure_response", stat);
            }
            if (AuthStatus.SEND_FAILURE == stat) {
                return this.helper.makeFaultResponse(info.getResponsePacket(), new Exception("Error in Securing Response"));
            }
            return info.getResponsePacket();
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "ws.error_secure_response", e);
                }
            } else {
                logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0054_ERROR_SECURE_RESPONSE(), e);
            }
            return this.helper.makeFaultResponse(info.getResponsePacket(), e);
        }
    }

    @Override
    public void preDestroy() {
        this.helper.disable();
        this.next.preDestroy();
        NonceManager.deleteInstance(this.wsEndpoint);
    }
}

