/*
 * Decompiled with CFR 0.152.
 */
package vraausage;

import java.io.File;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vraa.div.client.ClientConfiguration;
import vraa.div.client.Utils;
import vraa.div.client.configuration.InternalCertificate;
import vraa.div.client.configuration.InternalConfiguration;
import vraa.div.common.SignatureConfiguration;
import vraa.div.common.XadesManager;

public class SigningTest {
    public static void main(String[] args) throws Exception {
        SigningTest signingTest = new SigningTest();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File("unsigned.xml"));
        Element root = doc.getDocumentElement();
        System.out.println(root.getTagName());
        root = Utils.netify(root);
        Utils.printDOM(root);
        Element signature = SigningTest.signXml(root, "SenderSignature", new String[]{"SenderSection"});
        doc = root.getOwnerDocument();
        Element sig = doc.createElement("Signatures");
        sig.appendChild(doc.importNode(signature, true));
        root.appendChild(sig);
        System.out.println(SigningTest.getHash(signature));
        Utils.printDOM(root);
        SigningTest.verifyXml(root, null, null);
    }

    private static Element signXml(Element xml, String signatureId, String[] signedSectionIds) {
        ClientConfiguration conf = ClientConfiguration.fromConfig(null, null);
        InternalConfiguration internalConfig = InternalConfiguration.fromClientConfig(conf);
        InternalCertificate cert = internalConfig.getDefaultCertificate();
        XadesManager signatureManager = new XadesManager();
        SignatureConfiguration signatureConfig = new SignatureConfiguration();
        signatureConfig.setEntry(cert.getEntry());
        signatureConfig.setTsaAddress(null);
        return signatureManager.createSignature(xml, signatureConfig, signatureId, signedSectionIds);
    }

    private static boolean verifyXml(Element xml, String signatureId, String[] signedSectionIds) {
        XadesManager signatureManager = new XadesManager();
        return signatureManager.verifySignature(xml, signatureId, signedSectionIds);
    }

    private static String getHash(Element sign) throws XPathExpressionException {
        XPath xp = XPathFactory.newInstance().newXPath();
        NamespaceContext ctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new NullPointerException("Null prefix");
                }
                if ("en".equals(prefix)) {
                    return "http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0";
                }
                if ("ds".equals(prefix)) {
                    return "http://www.w3.org/2000/09/xmldsig#";
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            @Override
            public String getPrefix(String uri) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String uri) {
                throw new UnsupportedOperationException();
            }
        };
        xp.setNamespaceContext(ctx);
        return (String)xp.evaluate("//ds:Reference[@URI='#SenderSection']", sign, XPathConstants.STRING);
    }
}

