/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.common;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import net.java.xades.security.xml.SignatureStatus;
import net.java.xades.security.xml.ValidateResult;
import net.java.xades.security.xml.XAdES.XAdES;
import net.java.xades.security.xml.XAdES.XAdES_BES;
import net.java.xades.security.xml.XAdES.XMLAdvancedSignature;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.Utils;
import vraa.div.common.SignatureConfiguration;

public class XadesManager {
    public Element createSignature(Element xml, SignatureConfiguration signatureConfig, String signatureId, String[] signedSectionIds) {
        try {
            xml = Utils.netify(xml);
            XAdES_BES xades = XAdES.newInstance(XAdES.BES, "http://uri.etsi.org/01903/v1.3.2#", "xades", "ds", "http://www.w3.org/2001/04/xmlenc#sha512", xml.getOwnerDocument(), xml);
            xades.setSigningCertificate(signatureConfig.getCertificate());
            XMLAdvancedSignature xmlSignature = XMLAdvancedSignature.newInstance(xades);
            xmlSignature.setSignatureId(signatureId);
            xmlSignature.sign(signatureConfig.getCertificate(), signatureConfig.getPrivateKey(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", Arrays.asList(signedSectionIds), "ds");
            NodeList list = xml.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            Element signature = null;
            int j = list.getLength();
            for (int i = 0; i < j; ++i) {
                if (!signatureId.equals(((Element)list.item(i)).getAttribute("Id"))) continue;
                signature = (Element)list.item(i);
            }
            return signature;
        }
        catch (Exception ice) {
            throw ExceptionBuilder.Internal(null, ice);
        }
    }

    public boolean verifySignature(Element xml, String signatureId, String[] requiredSectionIds) {
        try {
            XAdES_BES xades = XAdES.newInstance(XAdES.BES, xml);
            XMLAdvancedSignature xmlSignature = XMLAdvancedSignature.newInstance(xades);
            List<SignatureStatus> st = xmlSignature.validate();
            boolean validate = true;
            for (SignatureStatus status : st) {
                if (status.getValidateResult() == ValidateResult.VALID) continue;
                System.out.println("Sign validation error: ");
                System.out.println(status.getReasonsAsText());
                validate = false;
            }
            if (validate) {
                System.out.println("OK");
            }
            return validate;
        }
        catch (GeneralSecurityException gse) {
            throw ExceptionBuilder.Internal(null, gse);
        }
    }
}

