/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.mailbox.FileDecryptInfo;
import vraa.div.client.mailbox.LargeFileReceiveInputStream;

public class FileReceiveContent {
    private FileDecryptInfo decryptInfo;
    private byte[] content;
    private String messageId;
    private String contentId;
    private long partCount;

    public FileDecryptInfo getDecryptInfo() {
        return this.decryptInfo;
    }

    public FileReceiveContent(FileDecryptInfo decryptInfo, byte[] content) {
        if (decryptInfo == null) {
            throw ExceptionBuilder.ArgumentNull("decryptInfo");
        }
        if (content == null) {
            throw ExceptionBuilder.ArgumentNull("content");
        }
        this.decryptInfo = decryptInfo;
        this.content = content;
    }

    public FileReceiveContent(FileDecryptInfo decryptInfo, String messageId, String contentId, long partCount) {
        if (decryptInfo == null) {
            throw ExceptionBuilder.ArgumentNull("decryptInfo");
        }
        if (messageId == null) {
            throw ExceptionBuilder.ArgumentNull("messageId");
        }
        if (contentId == null) {
            throw ExceptionBuilder.ArgumentNull("contentId");
        }
        this.decryptInfo = decryptInfo;
        this.messageId = messageId;
        this.contentId = contentId;
        this.partCount = partCount;
    }

    public InputStream createContentStream(IntegrationClientContext context) {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return new LargeFileReceiveInputStream(this.messageId, this.contentId, this.partCount, context);
    }
}

