/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.AddresseesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.AppendicesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ApprovalStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.AuthorsStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.CommonMetadataStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.DocumentKindStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.DocumentSignaturesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.GeneralMetadataStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.LanguagesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ObjectFactory;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.PreparersStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ReferencesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ResolutionsStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.StateArchiveInfoStructure;
import vraa.div.client.CorrespondentCollection;
import vraa.div.client.DocumentAppendixCollection;
import vraa.div.client.DocumentApproval;
import vraa.div.client.DocumentArchiveInfo;
import vraa.div.client.DocumentExtendedMetadata;
import vraa.div.client.DocumentReferenceCollection;
import vraa.div.client.DocumentResolutionCollection;
import vraa.div.client.DocumentSignatureCollection;
import vraa.div.client.IntegrationMessage;
import vraa.div.client.MessageDocumentKind;
import vraa.div.client.MessageFileCollection;
import vraa.div.client.OfficerCollection;
import vraa.div.client.Utils;

public class MessageDocument {
    private CorrespondentCollection addressees;
    private DocumentAppendixCollection appendices;
    private DocumentApproval approval;
    private DocumentArchiveInfo archiveInfo;
    private CorrespondentCollection authors;
    private XMLGregorianCalendar date;
    private String description;
    private DocumentExtendedMetadata extendedMetadata;
    private MessageFileCollection files;
    private Boolean limitedAvailability;
    private MessageDocumentKind kind;
    private List<String> languages;
    private String place;
    private OfficerCollection preparers;
    private DocumentReferenceCollection references;
    private String registrationNumber;
    private DocumentResolutionCollection resolutions;
    private DocumentSignatureCollection signatures;
    private String title;
    IntegrationMessage _message;
    private boolean _hasCommonMetadata;

    MessageDocument() {
    }

    public CorrespondentCollection getAddressees() {
        if (this.addressees == null) {
            this.addressees = new CorrespondentCollection();
        }
        return this.addressees;
    }

    public DocumentAppendixCollection getAppendices() {
        if (this.appendices == null) {
            this.appendices = new DocumentAppendixCollection();
        }
        return this.appendices;
    }

    public void setApproval(DocumentApproval approval) {
        this.approval = approval;
    }

    public DocumentApproval getApproval() {
        return this.approval;
    }

    public void setArchiveInfo(DocumentArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public DocumentArchiveInfo getArchiveInfo() {
        return this.archiveInfo;
    }

    public CorrespondentCollection getAuthors() {
        if (this.authors == null) {
            this.authors = new CorrespondentCollection();
        }
        return this.authors;
    }

    public void setDate(Date date) {
        this.date = Utils.dateToXML(date);
    }

    public Date getDate() {
        return Utils.XMLToDate(this.date);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentExtendedMetadata getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public MessageFileCollection getFiles() {
        if (this.files == null) {
            this.files = new MessageFileCollection();
        }
        return this.files;
    }

    public void setLimitedAvailability(Boolean limitedAvailability) {
        this.limitedAvailability = limitedAvailability;
    }

    public Boolean getLimitedAvailability() {
        return this.limitedAvailability;
    }

    public void setKind(MessageDocumentKind kind) {
        this.kind = kind;
    }

    public MessageDocumentKind getKind() {
        return this.kind;
    }

    public List<String> getLanguages() {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        return this.languages;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getPlace() {
        return this.place;
    }

    public OfficerCollection getPreparers() {
        if (this.preparers == null) {
            this.preparers = new OfficerCollection();
        }
        return this.preparers;
    }

    public DocumentReferenceCollection getReferences() {
        if (this.references == null) {
            this.references = new DocumentReferenceCollection();
        }
        return this.references;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setResolutions(DocumentResolutionCollection resolutions) {
        this.resolutions = resolutions;
    }

    public DocumentResolutionCollection getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = new DocumentResolutionCollection();
        }
        return this.resolutions;
    }

    public DocumentSignatureCollection getSignatures() {
        if (this.signatures == null) {
            this.signatures = new DocumentSignatureCollection();
        }
        return this.signatures;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    GeneralMetadataStructure getGeneralSchemaType() {
        GeneralMetadataStructure general = new GeneralMetadataStructure();
        if (this.getAuthors().size() > 0) {
            AuthorsStructure as = new AuthorsStructure();
            as.getAuthorEntry().addAll(this.authors.getSchemaType());
            general.setAuthors(as);
        }
        general.setDate(this.date);
        if (this.kind != null) {
            DocumentKindStructure kindS = new DocumentKindStructure();
            kindS.setDocumentKindCode(this.kind.getCode());
            kindS.setDocumentKindVersion(this.kind.getVersion());
            kindS.setDocumentKindName(this.kind.getName());
            general.setDocumentKind(kindS);
        }
        general.setDescription(this.description);
        if (this.getLanguages().size() > 0) {
            LanguagesStructure ls = new LanguagesStructure();
            ls.getLanguage().addAll(this.languages);
            general.setLanguages(ls);
        }
        general.setTitle(this.title);
        return general;
    }

    void setGeneralSchemaType(GeneralMetadataStructure general) {
        if (general.getAuthors() != null) {
            this.authors.setSchemaType(general.getAuthors().getAuthorEntry());
        }
        this.date = general.getDate();
        if (general.getDocumentKind() != null) {
            DocumentKindStructure kindS = general.getDocumentKind();
            this.kind.setCode(kindS.getDocumentKindCode());
            this.kind.setVersion(kindS.getDocumentKindVersion());
            this.kind.setName(kindS.getDocumentKindName());
        } else {
            this.kind = null;
        }
        this.description = general.getDescription();
        if (general.getLanguages() != null) {
            this.languages.addAll(general.getLanguages().getLanguage());
        }
        this.title = general.getTitle();
    }

    CommonMetadataStructure getCommonSchemaType() {
        CommonMetadataStructure obj = null;
        if (this._hasCommonMetadata || this.getSignatures().size() > 0 || this.getAddressees().size() > 0 || this.place != null || this.approval != null || this.registrationNumber != null || this.getReferences().size() > 0 || this.getPreparers().size() > 0 || this.limitedAvailability != null || this.getResolutions().size() > 0 || this.archiveInfo != null || this.getAppendices().size() > 0) {
            Object rs;
            Object as;
            obj = new CommonMetadataStructure();
            List<Serializable> content = obj.getContent();
            ObjectFactory of = new ObjectFactory();
            if (this.getSignatures().size() > 0) {
                DocumentSignaturesStructure dss = of.createDocumentSignaturesStructure();
                dss.getSignatureEntry().addAll(this.signatures.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructureSignatures(dss));
            }
            if (this.getAddressees().size() > 0) {
                as = of.createAddresseesStructure();
                ((AddresseesStructure)as).getAddresseeEntry().addAll(this.addressees.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructureAddressees((AddresseesStructure)as));
            }
            if (this.place != null) {
                content.add((Serializable)of.createCommonMetadataStructurePlace(this.place));
            }
            if (this.approval != null) {
                content.add((Serializable)of.createCommonMetadataStructureApproval(this.approval.getSchemaType()));
            }
            if (this.registrationNumber != null) {
                content.add((Serializable)of.createCommonMetadataStructureRegistrationNumber(this.registrationNumber));
            }
            if (this.getReferences().size() > 0) {
                rs = of.createReferencesStructure();
                ((ReferencesStructure)rs).getReferenceEntry().addAll(this.references.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructureDocumentReferences((ReferencesStructure)rs));
            }
            if (this.getPreparers().size() > 0) {
                PreparersStructure ps = of.createPreparersStructure();
                ps.getPreparerEntry().addAll(this.preparers.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructurePreparers(ps));
            }
            if (this.limitedAvailability != null) {
                content.add((Serializable)of.createCommonMetadataStructureLimitedAvailability(this.limitedAvailability));
            }
            if (this.getResolutions().size() > 0) {
                rs = of.createResolutionsStructure();
                ((ResolutionsStructure)rs).getResolutionEntry().addAll(this.resolutions.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructureResolutions((ResolutionsStructure)rs));
            }
            if (this.archiveInfo != null) {
                content.add((Serializable)of.createCommonMetadataStructureStateArchiveInfo(this.archiveInfo.getSchemaType()));
            }
            if (this.getAppendices().size() > 0) {
                as = of.createAppendicesStructure();
                ((AppendicesStructure)as).getAppendixEntry().addAll(this.appendices.getSchemaType());
                content.add((Serializable)of.createCommonMetadataStructureAppendices((AppendicesStructure)as));
            }
        }
        return obj;
    }

    void setCommonSchemaType(CommonMetadataStructure obj) {
        if (obj != null) {
            this._hasCommonMetadata = true;
            List<Serializable> content = obj.getContent();
            for (Serializable sitem : content) {
                JAXBElement item = (JAXBElement)sitem;
                if (item.getName().getLocalPart().equals("Signatures")) {
                    this.signatures.setSchemaType(((DocumentSignaturesStructure)item.getValue()).getSignatureEntry());
                }
                if (item.getName().getLocalPart().equals("Addressees")) {
                    this.addressees.setSchemaType(((AddresseesStructure)item.getValue()).getAddresseeEntry());
                }
                if (item.getName().getLocalPart().equals("Place")) {
                    this.place = (String)item.getValue();
                }
                if (item.getName().getLocalPart().equals("Approval")) {
                    this.approval = new DocumentApproval();
                    this.approval.setSchemaType((ApprovalStructure)item.getValue());
                }
                if (item.getName().getLocalPart().equals("RegistrationNumber")) {
                    this.registrationNumber = (String)item.getValue();
                }
                if (item.getName().getLocalPart().equals("DocumentReferences")) {
                    this.references.setSchemaType(((ReferencesStructure)item.getValue()).getReferenceEntry());
                }
                if (item.getName().getLocalPart().equals("Preparers")) {
                    this.preparers.setSchemaType(((PreparersStructure)item.getValue()).getPreparerEntry());
                }
                if (item.getName().getLocalPart().equals("LimitedAvailability")) {
                    this.limitedAvailability = (Boolean)item.getValue();
                }
                if (item.getName().getLocalPart().equals("Resolutions")) {
                    this.resolutions.setSchemaType(((ResolutionsStructure)item.getValue()).getResolutionEntry());
                }
                if (item.getName().getLocalPart().equals("StateArchiveInfo")) {
                    this.archiveInfo = new DocumentArchiveInfo();
                    this.archiveInfo.setSchemaType((StateArchiveInfoStructure)item.getValue());
                }
                if (!item.getName().getLocalPart().equals("Appendices")) continue;
                this.appendices.setSchemaType(((AppendicesStructure)item.getValue()).getAppendixEntry());
            }
        }
    }

    MessageDocument(IntegrationMessage message) {
        this._message = message;
        this.authors = new CorrespondentCollection();
        this.kind = new MessageDocumentKind();
        this.files = new MessageFileCollection();
        this.signatures = new DocumentSignatureCollection();
        this.addressees = new CorrespondentCollection();
        this.references = new DocumentReferenceCollection();
        this.preparers = new OfficerCollection();
        this.resolutions = new DocumentResolutionCollection();
        this.appendices = new DocumentAppendixCollection();
        this.languages = new ArrayList<String>();
        this.extendedMetadata = new DocumentExtendedMetadata();
    }
}

