/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.DocumentMetadataEntryStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.DocumentPayloadStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.EnvelopeStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ExtendedMetadataStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ObjectFactory;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.PriorityType;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.RecipientsStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.SenderDocumentStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.SenderTransportMetadataStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ServerConfirmationPartStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ServerTransportMetadataStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.SignaturesStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.TraceInfoEntryStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.TraceInfoStructure;
import org.w3._2000._09.xmldsig.SignatureType;
import org.w3c.dom.Element;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.FileReceiveContext;
import vraa.div.client.MessageDocument;
import vraa.div.client.MessageDocumentKind;
import vraa.div.client.MessagePriority;
import vraa.div.client.MessageRecipient;
import vraa.div.client.MessageRecipientCollection;
import vraa.div.client.MessageRecipientConfirmationInfo;
import vraa.div.client.MessageServerConfirmation;
import vraa.div.client.MessageSignature;
import vraa.div.client.Utils;
import vraa.div.common.Envelope;
import vraa.div.common.XadesManager;

public class IntegrationMessage {
    private String clientId;
    private MessageRecipientConfirmationInfo confirmationInfo;
    private MessageDocument document;
    private Boolean enableEncryption;
    private boolean enableNotifications;
    private String from;
    private String messageId;
    private MessagePriority priority;
    private XMLGregorianCalendar recipientAvailableOn;
    private MessageRecipientCollection recipients;
    private XMLGregorianCalendar serverReceivedOn;
    private Map<String, String> traceInfo;
    private List<SignatureType> signatures = new ArrayList<SignatureType>();
    private XMLGregorianCalendar senderDeliveryBy;
    private XMLGregorianCalendar serverDeliveryBy;

    public IntegrationMessage() {
        this.recipients = new MessageRecipientCollection();
        this.document = new MessageDocument(this);
        this.document.setDate(new Date());
        this.document.setKind(new MessageDocumentKind());
        this.document.getKind().setVersion("1.0");
        this.clientId = UUID.randomUUID().toString().replaceAll("-", "");
        this.enableNotifications = true;
        this.priority = MessagePriority.Normal;
        this.traceInfo = new HashMap<String, String>();
        this.signatures = new ArrayList<SignatureType>();
    }

    public IntegrationMessage(Element xml) {
        this();
        if (xml == null) {
            throw ExceptionBuilder.ArgumentNull("xml");
        }
        this.setSchemaType(Envelope.deserialize(EnvelopeStructure.class, xml));
    }

    public IntegrationMessage(String xml) {
        this();
        if (xml == null) {
            throw ExceptionBuilder.ArgumentNull("xml");
        }
        this.setSchemaType(Envelope.deserialize(EnvelopeStructure.class, Utils.stringToXml(xml)));
    }

    public void append(MessageServerConfirmation confirmation) {
        if (confirmation == null) {
            throw ExceptionBuilder.ArgumentNull("confirmation");
        }
        if (this.signatures.size() == 0) {
            throw ExceptionBuilder.Client("BL.BIB.015", new Object[0]);
        }
        SignatureType serverSignature = null;
        for (SignatureType s : this.signatures) {
            if (!"ServerSignature".equals(s.getId())) continue;
            serverSignature = s;
        }
        if (this.signatures.size() > 1 || serverSignature != null || !Utils.isNullOrEmpty(this.messageId)) {
            throw ExceptionBuilder.Client("BL.BIB.016", new Object[0]);
        }
        Element xml = confirmation.getXml();
        ServerConfirmationPartStructure serverPart = Envelope.deserialize(ServerConfirmationPartStructure.class, xml);
        if (serverPart != null) {
            if (serverPart.getServerTransportMetadata() != null) {
                this.setServerTransportSchemaType(serverPart.getServerTransportMetadata());
            }
            if (serverPart.getSignatures() != null && serverPart.getSignatures().getSignature().size() > 0) {
                this.signatures.add(serverPart.getSignatures().getSignature().get(0));
            }
        }
    }

    public boolean validateSignature(MessageSignature signature) {
        String[] sections;
        String id;
        if (signature == MessageSignature.Sender) {
            id = "SenderSignature";
            sections = new String[]{"SenderSection"};
        } else if (signature == MessageSignature.Server) {
            id = "ServerSignature";
            sections = new String[]{"SenderSection", "ServerSection"};
        } else {
            String msg = "validateSignatureUnknown";
            throw ExceptionBuilder.Technical(msg, new Object[0]);
        }
        SignatureType signatureType = null;
        for (SignatureType s : this.signatures) {
            if (!s.getId().equals(id)) continue;
            signatureType = s;
            break;
        }
        if (signatureType == null) {
            throw ExceptionBuilder.Client("BL.BIB.014", new Object[]{signature});
        }
        Element xml = this.getXml();
        XadesManager signatureManager = new XadesManager();
        boolean result = signatureManager.verifySignature(xml, id, sections);
        return result;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setConfirmationInfo(MessageRecipientConfirmationInfo confirmationInfo) {
        this.confirmationInfo = confirmationInfo;
    }

    public MessageRecipientConfirmationInfo getConfirmationInfo() {
        return this.confirmationInfo;
    }

    public void setDeliveryBy(Date deliveryBy) {
        this.senderDeliveryBy = Utils.dateToXML(deliveryBy);
        if (this.serverDeliveryBy != null) {
            this.serverDeliveryBy = this.senderDeliveryBy;
        }
    }

    public Date getDeliveryBy() {
        if (this.serverDeliveryBy != null) {
            return Utils.XMLToDate(this.serverDeliveryBy);
        }
        return Utils.XMLToDate(this.senderDeliveryBy);
    }

    public MessageDocument getDocument() {
        if (this.document == null) {
            this.document = new MessageDocument();
        }
        return this.document;
    }

    public void setEnableEncryption(Boolean enableEncryption) {
        this.enableEncryption = enableEncryption;
    }

    public Boolean getEnableEncryption() {
        return this.enableEncryption;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setPriority(MessagePriority priority) {
        this.priority = priority;
    }

    public MessagePriority getPriority() {
        return this.priority;
    }

    public Date getRecipientAvailableOn() {
        return Utils.XMLToDate(this.recipientAvailableOn);
    }

    public MessageRecipientCollection getRecipients() {
        if (this.recipients == null) {
            this.recipients = new MessageRecipientCollection();
        }
        return this.recipients;
    }

    public Date getServerReceivedOn() {
        return Utils.XMLToDate(this.serverReceivedOn);
    }

    public void setTo(String to) {
        this.recipients.clear();
        if (to != null && !to.isEmpty()) {
            String[] eAddresses;
            for (String address : eAddresses = to.split(";")) {
                String taddr = address.trim();
                if (taddr.isEmpty()) continue;
                this.recipients.add(taddr);
            }
        }
    }

    public String getTo() {
        StringBuilder sb = new StringBuilder();
        for (MessageRecipient r : this.recipients) {
            sb.append("; ").append(r.getEAddress());
        }
        if (sb.length() > 0) {
            sb.delete(0, 2);
        }
        return sb.toString();
    }

    public void setTraceInfo(Map<String, String> traceInfo) {
        this.traceInfo = traceInfo;
    }

    public Map<String, String> getTraceInfo() {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<String, String>();
        }
        return this.traceInfo;
    }

    public Element getXml() {
        return Envelope.serialize(new QName("http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0", "Envelope"), EnvelopeStructure.class, this.getSchemaType());
    }

    public String getXmlString() {
        Element xml = Envelope.serialize(new QName("http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0", "Envelope"), EnvelopeStructure.class, this.getSchemaType());
        return Utils.xmlToString(xml);
    }

    public void setDocument(MessageDocument document) {
        this.document = document;
    }

    public void setRecipientAvailableOn(Date recipientAvailableOn) {
        this.recipientAvailableOn = Utils.dateToXML(recipientAvailableOn);
    }

    public void setRecipients(MessageRecipientCollection recipients) {
        this.recipients = recipients;
    }

    public void setServerReceivedOn(Date serverReceivedOn) {
        this.serverReceivedOn = Utils.dateToXML(serverReceivedOn);
    }

    public EnvelopeStructure getSchemaType() {
        ObjectFactory of = new ObjectFactory();
        EnvelopeStructure envelope = new EnvelopeStructure();
        DocumentMetadataEntryStructure metadataEntry = new DocumentMetadataEntryStructure();
        metadataEntry.setGeneralMetadata(this.document.getGeneralSchemaType());
        if (this.document.getFiles().getSchemaType().size() > 0) {
            DocumentPayloadStructure ps = of.createDocumentPayloadStructure();
            ps.getFile().addAll(this.document.getFiles().getSchemaType());
            metadataEntry.setPayloadReference(ps);
        }
        metadataEntry.setCommonMetadata(this.document.getCommonSchemaType());
        if (this.document.getExtendedMetadata().getSchemaType().size() > 0) {
            ExtendedMetadataStructure ems = of.createExtendedMetadataStructure();
            ems.getContent().addAll(this.document.getExtendedMetadata().getSchemaType());
            metadataEntry.setExtendedMetadata(ems);
        }
        SenderDocumentStructure senderDoc = new SenderDocumentStructure();
        senderDoc.setId("SenderSection");
        senderDoc.setSenderTransportMetadata(this.getSenderTransportSchemaType());
        senderDoc.setDocumentMetadata(metadataEntry);
        envelope.setSenderDocument(senderDoc);
        envelope.setServerTransportMetadata(this.getServerTransportSchemaType());
        if (this.signatures.size() > 0) {
            SignaturesStructure ss = new SignaturesStructure();
            ss.getSignature().addAll(this.signatures);
            envelope.setSignatures(ss);
        }
        return envelope;
    }

    public void setSchemaType(EnvelopeStructure envelope) {
        SenderDocumentStructure senderDoc = envelope.getSenderDocument();
        if (senderDoc != null) {
            if (senderDoc.getSenderTransportMetadata() != null) {
                this.setSenderTransportSchemaType(senderDoc.getSenderTransportMetadata());
            }
            if (senderDoc.getDocumentMetadata() != null) {
                DocumentMetadataEntryStructure metadataEntry = senderDoc.getDocumentMetadata();
                if (metadataEntry.getGeneralMetadata() != null) {
                    this.document.setGeneralSchemaType(metadataEntry.getGeneralMetadata());
                }
                if (metadataEntry.getPayloadReference() != null) {
                    this.document.getFiles().setSchemaType(metadataEntry.getPayloadReference().getFile());
                }
                if (metadataEntry.getCommonMetadata() != null) {
                    this.document.setCommonSchemaType(metadataEntry.getCommonMetadata());
                }
                if (metadataEntry.getExtendedMetadata() != null) {
                    this.document.getExtendedMetadata().setSchemaType(metadataEntry.getExtendedMetadata().getContent());
                }
            }
        }
        if (envelope.getServerTransportMetadata() != null) {
            this.setServerTransportSchemaType(envelope.getServerTransportMetadata());
        }
        this.signatures.clear();
        if (envelope.getSignatures() != null) {
            this.signatures.addAll(envelope.getSignatures().getSignature());
        }
    }

    private SenderTransportMetadataStructure getSenderTransportSchemaType() {
        SenderTransportMetadataStructure transport = new SenderTransportMetadataStructure();
        transport.setSenderEAddress(this.from);
        transport.setSenderRefNumber(this.clientId);
        RecipientsStructure rs = new RecipientsStructure();
        rs.getRecipientEntry().addAll(this.recipients.getSchemaType());
        transport.setRecipients(rs);
        transport.setNotifySenderOnDelivery(this.enableNotifications);
        if (this.senderDeliveryBy != null) {
            transport.setDeliveryDeadline(this.senderDeliveryBy);
        }
        switch (this.priority) {
            case Low: {
                transport.setPriority(PriorityType.LOW);
                break;
            }
            case High: {
                transport.setPriority(PriorityType.HIGH);
                break;
            }
            default: {
                transport.setPriority(PriorityType.NORMAL);
            }
        }
        if (this.traceInfo.size() > 0) {
            TraceInfoStructure tis = new TraceInfoStructure();
            List<TraceInfoEntryStructure> entries = tis.getTraceInfoEntry();
            for (Map.Entry<String, String> pair : this.traceInfo.entrySet()) {
                TraceInfoEntryStructure ties = new TraceInfoEntryStructure();
                ties.setTraceInfoID(pair.getKey());
                ties.setTraceText(pair.getValue());
                entries.add(ties);
            }
            transport.setTraceInfo(tis);
        }
        return transport;
    }

    void setSenderTransportSchemaType(SenderTransportMetadataStructure transport) {
        this.from = transport.getSenderEAddress();
        this.clientId = transport.getSenderRefNumber();
        if (this.recipients == null) {
            this.recipients = new MessageRecipientCollection();
        }
        if (this.document == null) {
            this.document = new MessageDocument(this);
        }
        if (transport.getRecipients() != null) {
            this.recipients.setSchemaType(transport.getRecipients().getRecipientEntry());
            this.enableEncryption = this.getEncryptionSetting();
        }
        this.enableNotifications = transport.isNotifySenderOnDelivery();
        if (transport.getDeliveryDeadline() != null) {
            this.senderDeliveryBy = transport.getDeliveryDeadline();
        }
        switch (transport.getPriority()) {
            case HIGH: {
                this.priority = MessagePriority.High;
                break;
            }
            case LOW: {
                this.priority = MessagePriority.Low;
                break;
            }
            default: {
                this.priority = MessagePriority.Normal;
            }
        }
        if (transport.getTraceInfo() != null) {
            for (TraceInfoEntryStructure traceItem : transport.getTraceInfo().getTraceInfoEntry()) {
                this.traceInfo.put(traceItem.getTraceInfoID(), traceItem.getTraceText());
            }
        }
    }

    private ServerTransportMetadataStructure getServerTransportSchemaType() {
        ServerTransportMetadataStructure schemaStruct = null;
        if (this.messageId != null && !this.messageId.isEmpty()) {
            schemaStruct = new ServerTransportMetadataStructure();
            schemaStruct.setId("ServerSection");
            schemaStruct.setServerReceivedTime(this.serverReceivedOn);
            schemaStruct.setServerRefNumber(this.messageId);
            schemaStruct.setDeliveryDeadline(this.serverDeliveryBy);
            schemaStruct.setAvailabilityTime(this.recipientAvailableOn);
        }
        return schemaStruct;
    }

    void setServerTransportSchemaType(ServerTransportMetadataStructure schemaStruct) {
        this.serverReceivedOn = schemaStruct.getServerReceivedTime();
        this.messageId = schemaStruct.getServerRefNumber();
        this.serverDeliveryBy = schemaStruct.getDeliveryDeadline();
        this.recipientAvailableOn = schemaStruct.getAvailabilityTime();
    }

    public FileReceiveContext createFileContext() {
        return new FileReceiveContext(this);
    }

    public Boolean getEncryptionSetting() {
        Boolean encrypted = null;
        boolean hasFilled = false;
        boolean hasEmpty = false;
        for (MessageRecipient recipient : this.recipients) {
            boolean hasKey;
            boolean hasCert = recipient.getCertificateThumbprint() != null && !recipient.getCertificateThumbprint().isEmpty();
            boolean bl = hasKey = recipient.getEncryptedKey() != null && !recipient.getEncryptedKey().isEmpty();
            if (!(hasCert ^ hasKey)) {
                if (hasCert) {
                    hasFilled = true;
                    continue;
                }
                hasEmpty = true;
                continue;
            }
            hasFilled = true;
            hasEmpty = true;
            break;
        }
        if (hasFilled ^ hasEmpty) {
            encrypted = hasFilled;
        }
        return encrypted;
    }

    public void clearSignatures() {
        this.signatures.clear();
    }

    public void addSignature(SignatureType signature) {
        this.signatures.add(signature);
    }
}

