/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ReferenceEntryStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ReferenceKindTypeStructure;
import vraa.div.client.Code;
import vraa.div.client.Correspondent;
import vraa.div.client.Utils;

public class DocumentReference {
    private Correspondent author;
    private Correspondent originalAuthor;
    private XMLGregorianCalendar date;
    private String refRegistrationNumber;
    private Code referenceKind;

    public DocumentReference() {
    }

    public DocumentReference(String registrationNumber) {
        this.refRegistrationNumber = registrationNumber;
    }

    public void setAuthor(Correspondent author) {
        this.author = author;
    }

    public Correspondent getAuthor() {
        return this.author;
    }

    public void setDate(Date date) {
        this.date = Utils.dateToXML(date);
    }

    public Date getDate() {
        return Utils.XMLToDate(this.date);
    }

    public void setRefRegistrationNumber(String refRegistrationNumber) {
        this.refRegistrationNumber = refRegistrationNumber;
    }

    public String getRefRegistrationNumber() {
        return this.refRegistrationNumber;
    }

    public void setOriginalAuthor(Correspondent originalAuthor) {
        this.originalAuthor = originalAuthor;
    }

    public Correspondent getOriginalAuthor() {
        return this.originalAuthor;
    }

    public void setReferenceKind(Code referenceKind) {
        this.referenceKind = referenceKind;
    }

    public Code getReferenceKind() {
        return this.referenceKind;
    }

    ReferenceEntryStructure getSchemaType() {
        ReferenceEntryStructure s = new ReferenceEntryStructure();
        s.setRefRegistrationNumber(this.refRegistrationNumber);
        if (this.date != null) {
            s.setDate(this.date);
        }
        if (this.getAuthor() != null) {
            s.setAuthor(this.author.getSchemaType());
        }
        if (this.getOriginalAuthor() != null) {
            s.setOriginalAuthor(this.originalAuthor.getSchemaType());
        }
        if (this.referenceKind != null) {
            s.setReferenceKind(new ReferenceKindTypeStructure());
            this.referenceKind.toSchemaItem(s.getReferenceKind());
        }
        return s;
    }

    void setSchemaType(ReferenceEntryStructure s) {
        this.refRegistrationNumber = s.getRefRegistrationNumber();
        if (s.getDate() != null) {
            this.date = s.getDate();
        }
        if (s.getAuthor() != null) {
            this.author = new Correspondent(s.getAuthor());
        }
        if (s.getOriginalAuthor() != null) {
            this.originalAuthor = new Correspondent(s.getOriginalAuthor());
        }
        if (s.getReferenceKind() != null) {
            this.referenceKind = new Code();
            this.referenceKind.fromSchemaItem(s.getReferenceKind());
        }
    }
}

