/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceHelper {
    private String classFileName;
    private String resourceFolderName;
    private URL resourceURL;
    private Enumeration<ResourceEntry> resourceEntries;

    public ResourceHelper(Class clazz) throws IOException {
        this(clazz, null);
    }

    public ResourceHelper(Class clazz, String resourceFolderName) throws IOException {
        this.resourceFolderName = resourceFolderName;
        this.classFileName = clazz.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = clazz.getClassLoader();
        this.resourceURL = ClassLoader.getSystemResource(this.classFileName);
        if (this.resourceURL == null) {
            this.resourceURL = classLoader.getResource(this.classFileName);
        }
        if (this.resourceURL == null) {
            throw new IOException("Impossible to find Resource URL.");
        }
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public Enumeration<ResourceEntry> resourceEntries() throws IOException {
        if (this.resourceEntries == null) {
            String protocol = this.resourceURL.getProtocol().toLowerCase();
            if ("file".equals(protocol)) {
                String path = this.resourceURL.getPath();
                int pos = path.length() - this.classFileName.length();
                String basePath = path.substring(0, pos);
                File baseFolder = new File(basePath);
                if (this.resourceFolderName != null) {
                    baseFolder = new File(baseFolder, this.resourceFolderName);
                }
                ArrayList<File> fileStore = new ArrayList<File>();
                this.loadFiles(baseFolder, fileStore);
                return new FileResourceEntries(fileStore);
            }
            if ("jar".equals(protocol)) {
                JarURLConnection jarConn = (JarURLConnection)this.resourceURL.openConnection();
                JarFile jarFile = jarConn.getJarFile();
                this.resourceEntries = new JarResourceEntries(jarFile, this.resourceFolderName);
            } else {
                this.resourceEntries = new EmptyResourceEntries();
            }
        }
        return this.resourceEntries;
    }

    private void loadFiles(File folder, List<File> fileStore) {
        for (File file : folder.listFiles()) {
            fileStore.add(file);
            if (!file.isDirectory()) continue;
            this.loadFiles(file, fileStore);
        }
    }

    private static class JarResourceEntry
    implements ResourceEntry {
        private JarFile jarFile;
        private JarEntry entry;

        public JarResourceEntry(JarFile jarFile, JarEntry entry) {
            this.entry = entry;
            this.jarFile = jarFile;
        }

        @Override
        public String getPathName() {
            return this.entry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.entry);
        }
    }

    private static class FileResourceEntry
    implements ResourceEntry {
        private File file;

        public FileResourceEntry(File file) {
            this.file = file;
        }

        @Override
        public String getPathName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    public static interface ResourceEntry {
        public String getPathName();

        public boolean isDirectory();

        public InputStream getInputStream() throws IOException;
    }

    private static class FileResourceEntries
    implements Enumeration<ResourceEntry> {
        private Iterator<File> entries;

        public FileResourceEntries(List<File> fileStore) {
            this.entries = fileStore.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries.hasNext();
        }

        @Override
        public ResourceEntry nextElement() {
            return new FileResourceEntry(this.entries.next());
        }
    }

    private static class JarResourceEntries
    implements Enumeration<ResourceEntry> {
        private JarFile jarFile;
        private Iterator<JarEntry> entries;

        public JarResourceEntries(JarFile jarFile, String resourceFolderName) {
            this.jarFile = jarFile;
            ArrayList<JarEntry> jarEntryList = new ArrayList<JarEntry>();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                if (resourceFolderName != null && !entry.getName().startsWith(resourceFolderName)) continue;
                jarEntryList.add(entry);
            }
            this.entries = jarEntryList.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries.hasNext();
        }

        @Override
        public ResourceEntry nextElement() {
            return new JarResourceEntry(this.jarFile, this.entries.next());
        }
    }

    private static class EmptyResourceEntries
    implements Enumeration<ResourceEntry> {
        private EmptyResourceEntries() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public ResourceEntry nextElement() {
            throw new NoSuchElementException();
        }
    }
}

