/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.common;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vraa.div.client.ExceptionBuilder;

public class Envelope {
    public static final String SchemaNamespace = "http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0";
    public static final String AddressSchemaNamespace = "http://ivis.eps.gov.lv/XMLSchemas/100001/Address/v1-1";
    public static final String SignatureSchemaNamespace = "http://www.w3.org/2000/09/xmldsig#";
    public static final String ShaAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RsaShaAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String SenderSectionId = "SenderSection";
    public static final String SenderSignatureId = "SenderSignature";
    public static final String ServerSectionId = "ServerSection";
    public static final String ServerSignatureId = "ServerSignature";
    public static final String RecipientSectionIdSuffix = "RecipientSection";
    public static final String RecipientSignatureIdSuffix = "RecipientSignature";
    public static final String EnvelopeElement = "Envelope";
    public static final String ServerConfirmationElement = "ServerConfirmationPart";
    public static final String RecipientConfirmationElement = "RecipientConfirmationPart";
    public static final String SignatureElement = "Signature";

    public static Element combineEnvelopeParts(String rootElement, Element[] parts) {
        try {
            Node imported;
            Element senderDoc = null;
            Element serverDoc = null;
            ArrayList<Element> recipientConfirmations = new ArrayList<Element>(0);
            ArrayList<Element> signatures = new ArrayList<Element>();
            boolean canHaveSenderDoc = false;
            boolean canHaveServerDoc = false;
            boolean canHaveConfirmations = false;
            for (Element xml : parts) {
                NodeList signatureNodes;
                int j;
                NodeList confirmNodes;
                Element node;
                String partRoot;
                boolean hasSomeInfo = false;
                String currentRoot = xml.getTagName();
                if (EnvelopeElement.equals(currentRoot)) {
                    canHaveConfirmations = true;
                    canHaveServerDoc = true;
                    canHaveSenderDoc = true;
                } else if (ServerConfirmationElement.equals(currentRoot)) {
                    canHaveServerDoc = true;
                } else if (RecipientConfirmationElement.equals(currentRoot)) {
                    canHaveConfirmations = true;
                } else {
                    if (SignatureElement.equals(currentRoot)) {
                        signatures.add(xml);
                        continue;
                    }
                    throw ExceptionBuilder.Envelope("combineInvalidXmlRoot", currentRoot);
                }
                XPath xp = XPathFactory.newInstance().newXPath();
                NamespaceContext ctx = new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        if (prefix == null) {
                            throw new NullPointerException("Null prefix");
                        }
                        if ("en".equals(prefix)) {
                            return Envelope.SchemaNamespace;
                        }
                        if ("ds".equals(prefix)) {
                            return Envelope.SignatureSchemaNamespace;
                        }
                        if ("xml".equals(prefix)) {
                            return "http://www.w3.org/XML/1998/namespace";
                        }
                        return "";
                    }

                    @Override
                    public String getPrefix(String uri) {
                        throw new UnsupportedOperationException();
                    }

                    public Iterator getPrefixes(String uri) {
                        throw new UnsupportedOperationException();
                    }
                };
                xp.setNamespaceContext(ctx);
                if (canHaveSenderDoc) {
                    partRoot = "/en:SenderDocument";
                    node = (Element)xp.evaluate("/en:" + currentRoot + partRoot, xml, XPathConstants.NODE);
                    if (node != null) {
                        hasSomeInfo = true;
                        if (senderDoc == null) {
                            senderDoc = node;
                        } else {
                            throw ExceptionBuilder.Envelope("combinePartAlreadyDefined", partRoot);
                        }
                    }
                }
                if (canHaveServerDoc) {
                    partRoot = "/en:ServerTransportMetadata";
                    node = (Element)xp.evaluate("/en:" + currentRoot + partRoot, xml, XPathConstants.NODE);
                    if (node != null) {
                        hasSomeInfo = true;
                        if (serverDoc == null) {
                            serverDoc = node;
                        } else {
                            throw ExceptionBuilder.Envelope("combinePartAlreadyDefined", partRoot);
                        }
                    }
                }
                if (canHaveConfirmations && (confirmNodes = (NodeList)xp.evaluate("/en:" + currentRoot + "/en:RecipientConfirmations/en:ConfirmationEntry", xml, XPathConstants.NODESET)).getLength() > 0) {
                    hasSomeInfo = true;
                    j = confirmNodes.getLength();
                    for (int i = 0; i < j; ++i) {
                        recipientConfirmations.add((Element)confirmNodes.item(i));
                    }
                }
                if ((signatureNodes = (NodeList)xp.evaluate("/en:" + currentRoot + "/en:Signatures/ds:Signature", xml, XPathConstants.NODESET)).getLength() > 0) {
                    hasSomeInfo = true;
                    j = signatureNodes.getLength();
                    for (int i = 0; i < j; ++i) {
                        signatures.add((Element)signatureNodes.item(i));
                    }
                }
                if (hasSomeInfo) continue;
                throw ExceptionBuilder.Envelope("combinePartNoInfo", new Object[0]);
            }
            DocumentBuilderFactory builderFact = DocumentBuilderFactory.newInstance();
            builderFact.setNamespaceAware(true);
            DocumentBuilder builder = builderFact.newDocumentBuilder();
            Document envelopeXml = builder.newDocument();
            Element envelope = envelopeXml.createElementNS(SchemaNamespace, rootElement);
            envelopeXml.appendChild(envelope);
            if (senderDoc != null) {
                Node imported2 = envelopeXml.importNode(senderDoc, true);
                envelope.appendChild(imported2);
            }
            if (serverDoc != null) {
                Node imported3 = envelopeXml.importNode(serverDoc, true);
                envelope.appendChild(imported3);
            }
            if (recipientConfirmations.size() > 0) {
                Element confirmsElem = envelopeXml.createElementNS(SchemaNamespace, "RecipientConfirmations");
                envelope.appendChild(confirmsElem);
                for (Element node : recipientConfirmations) {
                    imported = envelopeXml.importNode(node, true);
                    confirmsElem.appendChild(imported);
                }
            }
            if (signatures.size() > 0) {
                Element signaturesElem = envelopeXml.createElementNS(SchemaNamespace, "Signatures");
                envelope.appendChild(signaturesElem);
                for (Element node : signatures) {
                    imported = envelopeXml.importNode(node, true);
                    signaturesElem.appendChild(imported);
                }
            }
            return envelopeXml.getDocumentElement();
        }
        catch (XPathExpressionException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
        catch (DOMException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionBuilder.Internal(null, e);
        }
    }

    public static <T> Element serialize(QName name, Class<T> type, T obj) {
        try {
            JAXBElement wrap = new JAXBElement(name, type, obj);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller mer = jc.createMarshaller();
            DOMResult writ = new DOMResult();
            mer.marshal((Object)wrap, (Result)writ);
            Envelope.removeNewLine(writ.getNode());
            return ((Document)writ.getNode()).getDocumentElement();
        }
        catch (JAXBException jaxbe) {
            throw new RuntimeException(jaxbe);
        }
    }

    private static void removeNewLine(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().replaceAll("\r\n", "\n"));
                child.setTextContent(child.getTextContent().replaceAll("\r", "\n"));
            }
            Envelope.removeNewLine(child);
        }
    }

    public static <T> T deserialize(Class<T> type, Element xml) {
        Object t = JAXB.unmarshal((Source)new DOMSource(xml), type);
        return (T)t;
    }

    public static String getRecipientSectionId(String confirmationName) {
        return confirmationName + RecipientSectionIdSuffix;
    }

    public static String getRecipientSignatureId(String confirmationName) {
        return confirmationName + RecipientSignatureIdSuffix;
    }
}

