/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.MessageFile;

public class MessageFileInputStream
extends InputStream {
    private boolean closeStream;
    private InputStream _stream;

    public MessageFileInputStream(MessageFile file, IntegrationClientContext context) {
        if (file.getContentBuffer() != null) {
            this._stream = new ByteArrayInputStream(file.getContentBuffer());
            this.closeStream = true;
        } else if (file.getContentStream() != null) {
            this._stream = file.getContentStream();
        } else if (file.getContentReceive() != null) {
            this._stream = file.getContentReceive().createContentStream(context);
            this.closeStream = true;
        } else {
            throw ExceptionBuilder.Technical("couldNotCreateMessageFileStream", new Object[0]);
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        return this._stream.read(buffer, offset, count);
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this._stream.read(buffer);
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            this._stream.close();
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        return this._stream.read();
    }
}

