/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.io.IOException;
import java.io.InputStream;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetAttachmentSectionInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetAttachmentSectionOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ObjectFactory;
import vraa.div.client.IntegrationClientContext;

public class LargeFileReceiveInputStream
extends InputStream {
    private String messageId;
    private String contentId;
    private long partCount;
    private IntegrationClientContext context;
    private long currentPart;
    private int indexInPart;
    private byte[] buffer;

    public LargeFileReceiveInputStream(String messageId, String contentId, long partCount, IntegrationClientContext context) {
        this.messageId = messageId;
        this.contentId = contentId;
        this.partCount = partCount;
        this.context = context;
        this.indexInPart = 0;
        this.currentPart = 0L;
        this.buffer = new byte[0];
    }

    @Override
    public int read() throws IOException {
        byte[] bb = new byte[1];
        int res = this.read(bb, 0, 1);
        if (res != -1) {
            res = bb[0] & 0xFF;
        }
        return res;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        int read = 0;
        while (count > 0 && (this.indexInPart < this.buffer.length || this.currentPart < this.partCount)) {
            int leftInBuffer;
            if (this.indexInPart >= this.buffer.length && this.currentPart < this.partCount) {
                GetAttachmentSectionInput request = new GetAttachmentSectionInput();
                ObjectFactory of = new ObjectFactory();
                request.setMessageId(of.createGetAttachmentSectionInputMessageId(this.messageId));
                request.setContentId(of.createGetAttachmentSectionInputContentId(this.contentId));
                request.setSectionIndex(this.currentPart);
                GetAttachmentSectionOutput response = this.context.call().getAttachmentSection(request);
                this.buffer = response.getContents().getValue() == null ? new byte[]{} : (byte[])response.getContents().getValue();
                ++this.currentPart;
                this.indexInPart = 0;
            }
            if ((leftInBuffer = this.buffer.length - this.indexInPart) <= 0) continue;
            int currentRead = leftInBuffer < count ? leftInBuffer : count;
            System.arraycopy(this.buffer, this.indexInPart, buffer, offset, currentRead);
            this.indexInPart += currentRead;
            offset += currentRead;
            read += currentRead;
            count -= currentRead;
        }
        return read == 0 ? -1 : read;
    }
}

