/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.xml.bind.DatatypeConverter;
import vraa.div.client.Utils;

public class FileTransformHelper {
    public static String send(InputStream inputStream, OutputStream outStream, Cipher cipher, boolean compress) {
        CipherOutputStream encryptStream = null;
        GZIPOutputStream compressStream = null;
        OutputStream actualWriteStream = outStream;
        try {
            if (cipher != null) {
                encryptStream = new CipherOutputStream(outStream, cipher);
                actualWriteStream = encryptStream;
            }
            if (compress) {
                compressStream = new GZIPOutputStream(actualWriteStream);
                actualWriteStream = compressStream;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            DigestInputStream digIn = new DigestInputStream(inputStream, md);
            Utils.copyPipe(digIn, actualWriteStream);
            digIn.close();
            actualWriteStream.close();
            byte[] hashBytes = md.digest();
            String hash = DatatypeConverter.printBase64Binary((byte[])hashBytes);
            return hash;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String receive(InputStream inputStream, OutputStream outputStream, Cipher cipher, boolean decompress) {
        CipherInputStream decryptStream = null;
        GZIPInputStream decompressStream = null;
        InputStream actualReadStream = inputStream;
        try {
            if (cipher != null) {
                decryptStream = new CipherInputStream(inputStream, cipher);
                actualReadStream = decryptStream;
            }
            if (decompress) {
                decompressStream = new GZIPInputStream(actualReadStream);
                actualReadStream = decompressStream;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            DigestInputStream digIn = new DigestInputStream(actualReadStream, md);
            Utils.copyPipe(digIn, outputStream);
            digIn.close();
            outputStream.close();
            byte[] hashBytes = md.digest();
            String hash = DatatypeConverter.printBase64Binary((byte[])hashBytes);
            return hash;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

