/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client.mailbox;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.configuration.InternalCertificate;
import vraa.div.client.mailbox.FileDecryptInfo;
import vraa.div.client.mailbox.FileDecryptKeyInfo;

public class FileDecryptor {
    private boolean initialized;
    private FileDecryptInfo decryptInfo;
    private Cipher cipher;

    private FileDecryptor() {
    }

    public static FileDecryptor createFromInfo(FileDecryptInfo decryptInfo) {
        FileDecryptor instance = new FileDecryptor();
        instance.decryptInfo = decryptInfo;
        return instance;
    }

    public static FileDecryptor createEmpty() {
        FileDecryptor instance = new FileDecryptor();
        instance.initialized = true;
        return instance;
    }

    public Cipher getCipher(IntegrationClientContext context) {
        if (!this.initialized) {
            this.initialize(context);
        }
        return this.cipher;
    }

    private void initialize(IntegrationClientContext context) {
        if (this.decryptInfo == null) {
            throw ExceptionBuilder.Technical("fileDecryptorNoInformation", new Object[0]);
        }
        if (this.decryptInfo.getEncrypted() == null) {
            throw ExceptionBuilder.Client("BL.BIB.025", new Object[0]);
        }
        if (this.decryptInfo.getEncrypted().booleanValue()) {
            FileDecryptKeyInfo key = this.decryptInfo.getEncryptedKey(context);
            if (key == null) {
                throw ExceptionBuilder.Client("BL.BIB.026", new Object[0]);
            }
            this.createCipher(key, context);
        }
        this.initialized = true;
    }

    private void createCipher(FileDecryptKeyInfo keyInfo, IntegrationClientContext context) {
        byte[] aesIV;
        byte[] aesKey;
        block9: {
            byte[] decryptedKey = null;
            aesKey = null;
            aesIV = null;
            try {
                InternalCertificate certificate = context.getConfiguration().getCertificates().get(keyInfo.getCertificateThumbprint().toLowerCase());
                Cipher cipherKey = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                cipherKey.init(2, certificate.getPrivateKey());
                byte[] encryptedKeyBytes = DatatypeConverter.parseBase64Binary((String)keyInfo.getEncryptedKey());
                decryptedKey = cipherKey.doFinal(encryptedKeyBytes);
                byte keyLength = decryptedKey[0];
                aesKey = Arrays.copyOfRange(decryptedKey, 1, keyLength + 1);
                aesIV = Arrays.copyOfRange(decryptedKey, keyLength + 1, decryptedKey.length);
                this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                this.cipher.init(2, (Key)new SecretKeySpec(aesKey, "AES"), new IvParameterSpec(aesIV));
                if (decryptedKey == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (decryptedKey != null) {
                        Arrays.fill(decryptedKey, (byte)0);
                    }
                    if (aesKey != null) {
                        Arrays.fill(aesKey, (byte)0);
                    }
                    if (aesIV != null) {
                        Arrays.fill(aesIV, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(decryptedKey, (byte)0);
        }
        if (aesKey != null) {
            Arrays.fill(aesKey, (byte)0);
        }
        if (aesIV != null) {
            Arrays.fill(aesIV, (byte)0);
        }
    }
}

