/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ServerConfirmationPartStructure;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ServerTransportMetadataStructure;
import org.w3c.dom.Element;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.Utils;
import vraa.div.common.Envelope;

public class MessageServerConfirmation {
    private XMLGregorianCalendar deliveryBy;
    private String messageId;
    private XMLGregorianCalendar recipientAvailableOn;
    private XMLGregorianCalendar serverReceivedOn;
    private Element xml;

    public MessageServerConfirmation(Element xml) {
        if (xml == null) {
            throw ExceptionBuilder.ArgumentNull("xml");
        }
        ServerConfirmationPartStructure schemaType = Envelope.deserialize(ServerConfirmationPartStructure.class, xml);
        ServerTransportMetadataStructure serverData = schemaType.getServerTransportMetadata();
        if (serverData != null) {
            this.messageId = serverData.getServerRefNumber();
            this.serverReceivedOn = serverData.getServerReceivedTime();
            this.deliveryBy = serverData.getDeliveryDeadline();
            this.recipientAvailableOn = serverData.getAvailabilityTime();
        }
        this.xml = xml;
    }

    public MessageServerConfirmation(String xmlStr) {
        if (xmlStr == null) {
            throw ExceptionBuilder.ArgumentNull("xml");
        }
        Element xml = Utils.stringToXml(xmlStr);
        ServerConfirmationPartStructure schemaType = Envelope.deserialize(ServerConfirmationPartStructure.class, xml);
        ServerTransportMetadataStructure serverData = schemaType.getServerTransportMetadata();
        if (serverData != null) {
            this.messageId = serverData.getServerRefNumber();
            this.serverReceivedOn = serverData.getServerReceivedTime();
            this.deliveryBy = serverData.getDeliveryDeadline();
            this.recipientAvailableOn = serverData.getAvailabilityTime();
        }
        this.xml = xml;
    }

    public Date getDeliveryBy() {
        return Utils.XMLToDate(this.deliveryBy);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Date getRecipientAvailableOn() {
        return Utils.XMLToDate(this.recipientAvailableOn);
    }

    public Date getServerReceivedOn() {
        return Utils.XMLToDate(this.serverReceivedOn);
    }

    public Element getXml() {
        return this.xml;
    }

    public String getXmlString() {
        return Utils.xmlToString(this.xml);
    }
}

