/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOflong;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ServerConfirmationPartStructure;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ActivateLegalPersonAccountInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ActivateNaturalPersonAccountInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeOwnerUpdateAsyncStartInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeOwnerUpdateAsyncStartOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeStatusUpdateAsyncStartInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeStatusUpdateAsyncStartOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfAddresseeOwnerUpdate;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfAddresseeRecord;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfAddresseeUnit;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfEAddressValidationResult;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfMessageHeader;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ArrayOfNotification;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ConfirmNotificationListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.CreateAddresseeUnitInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.CreateInstitutionInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.DeanullAddresseeInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.DeleteAddresseeUnitInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetActiveBulkReferenceNumberInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetActiveBulkReferenceNumberOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetAddresseeUnitInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetAddresseeUnitOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListAsyncConfirmInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListAsyncResultInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListAsyncResultOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListAsyncStartInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListAsyncStartOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetChangedAddresseeRecordListOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetInitialAddresseeRecordListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetInitialAddresseeRecordListOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageListOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageServerConfirmationInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetMessageServerConfirmationOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetNotificationListInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetNotificationListOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetResultJournalInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.GetResultJournalOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.MessageHeader;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ObjectFactory;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.SearchAddresseeUnitInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.SearchAddresseeUnitOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.UpdateAddresseeUnitInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateAddresseesAsyncConfirmInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateAddresseesAsyncResultInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateAddresseesAsyncResultOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateAddresseesAsyncStartInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateAddresseesAsyncStartOutput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateEAddressInput;
import lv.gov.vraa.xmlschemas.div.uui._2011._11.ValidateEAddressOutput;
import org.w3c.dom.Element;
import vraa.div.client.AddreesseePersonType;
import vraa.div.client.AddresseeOwnerUpdatePersonType;
import vraa.div.client.AddresseeOwnerUpdateRecord;
import vraa.div.client.AddresseeRecord;
import vraa.div.client.AddresseeStatusUpdatePersonType;
import vraa.div.client.AddresseeStatusUpdateStatusType;
import vraa.div.client.AddresseeUnit;
import vraa.div.client.AddresseeUnitSearchCriteria;
import vraa.div.client.ChangedAddresseeRecordsAsyncResult;
import vraa.div.client.ClientConfiguration;
import vraa.div.client.DataTranslatorExtensions;
import vraa.div.client.DeanullAddresseeType;
import vraa.div.client.EAddressValidationResult;
import vraa.div.client.ExceptionBuilder;
import vraa.div.client.FileReceiveContext;
import vraa.div.client.IntegrationClientContext;
import vraa.div.client.IntegrationMessage;
import vraa.div.client.IntegrationMessageHeader;
import vraa.div.client.ListToContinue;
import vraa.div.client.ListWithContinuationToken;
import vraa.div.client.MessageFile;
import vraa.div.client.MessageServerConfirmation;
import vraa.div.client.Notification;
import vraa.div.client.Owner;
import vraa.div.client.ResultJournalResult;
import vraa.div.client.Utils;
import vraa.div.client.configuration.InternalConfiguration;
import vraa.div.client.mailbox.FileDecryptor;
import vraa.div.client.mailbox.MessagingClient;
import vraa.div.common.Envelope;

public class IntegrationClient {
    private final int DEFAULT_LIST_FETCH_RECORD_COUNT = 50;
    private IntegrationClientContext context;
    private MessagingClient messaging;

    public IntegrationClient() {
        ClientConfiguration configuration = ClientConfiguration.fromConfig("div.client", null);
        InternalConfiguration internalConfig = InternalConfiguration.fromClientConfig(configuration);
        this.context = new IntegrationClientContext(internalConfig);
        this.messaging = new MessagingClient(this.context);
    }

    public IntegrationClient(String configurationSectionName, String fileName) {
        if (configurationSectionName == null) {
            throw ExceptionBuilder.ArgumentNull("configurationSectionName");
        }
        ClientConfiguration configuration = ClientConfiguration.fromConfig(configurationSectionName, fileName);
        InternalConfiguration internalConfig = InternalConfiguration.fromClientConfig(configuration);
        this.context = new IntegrationClientContext(internalConfig);
        this.messaging = new MessagingClient(this.context);
    }

    public IntegrationClient(ClientConfiguration configuration) {
        if (configuration == null) {
            throw ExceptionBuilder.ArgumentNull("configuration");
        }
        InternalConfiguration internalConfig = InternalConfiguration.fromClientConfig(configuration);
        this.context = new IntegrationClientContext(internalConfig);
        this.messaging = new MessagingClient(this.context);
    }

    public void activatePersonAccount(AddreesseePersonType type, Owner owner) {
        if (owner == null) {
            throw ExceptionBuilder.ArgumentNull("owner");
        }
        ObjectFactory of = new ObjectFactory();
        switch (type) {
            case NaturalPerson: {
                ActivateNaturalPersonAccountInput request = new ActivateNaturalPersonAccountInput();
                request.setOwner(of.createActivateNaturalPersonAccountInputOwner(DataTranslatorExtensions.toContract(owner)));
                this.context.call().activateNaturalPersonAccount(request);
                break;
            }
            case RegisteredEntity: {
                ActivateLegalPersonAccountInput request2 = new ActivateLegalPersonAccountInput();
                request2.setOwner(of.createActivateLegalPersonAccountInputOwner(DataTranslatorExtensions.toContract(owner)));
                this.context.call().activateLegalPersonAccount(request2);
            }
        }
    }

    public ListWithContinuationToken<AddresseeRecord> getInitialAddresseeRecords(String token) {
        GetInitialAddresseeRecordListInput request = new GetInitialAddresseeRecordListInput();
        ObjectFactory of = new ObjectFactory();
        request.setToken(of.createGetInitialAddresseeRecordListInputToken(token));
        GetInitialAddresseeRecordListOutput response = this.context.call().getInitialAddresseeRecordList(request);
        ListWithContinuationToken<AddresseeRecord> listAU = new ListWithContinuationToken<AddresseeRecord>();
        listAU.setContinuationToken((String)response.getContinuationToken().getValue());
        for (lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeRecord a : ((ArrayOfAddresseeRecord)response.getAddresseeRecords().getValue()).getAddresseeRecord()) {
            listAU.add(DataTranslatorExtensions.toData(a));
        }
        return listAU;
    }

    public String getActiveBulkReferenceNumber(String bulkOperationCode) {
        GetActiveBulkReferenceNumberInput request = new GetActiveBulkReferenceNumberInput();
        ObjectFactory of = new ObjectFactory();
        request.setBulkOperationCode(of.createGetActiveBulkReferenceNumberInputBulkOperationCode(bulkOperationCode));
        GetActiveBulkReferenceNumberOutput response = this.context.call().getActiveBulkReferenceNumber(request);
        return (String)response.getReferenceNumber().getValue();
    }

    public String addresseeOwnerUpdateAsyncStart(AddresseeOwnerUpdatePersonType addresseeType, Iterable<AddresseeOwnerUpdateRecord> addressees) {
        AddresseeOwnerUpdateAsyncStartInput request = new AddresseeOwnerUpdateAsyncStartInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeType(DataTranslatorExtensions.toContract(addresseeType));
        ArrayOfAddresseeOwnerUpdate arr = new ArrayOfAddresseeOwnerUpdate();
        for (AddresseeOwnerUpdateRecord a : addressees) {
            arr.getAddresseeOwnerUpdate().add(DataTranslatorExtensions.toContract(a));
        }
        request.setAddressees(of.createAddresseeOwnerUpdateAsyncStartInputAddressees(arr));
        AddresseeOwnerUpdateAsyncStartOutput response = this.context.call().addresseeOwnerUpdateAsyncStart(request);
        return (String)response.getRequestId().getValue();
    }

    public void deanullAddressee(DeanullAddresseeType addresseeType, String identificationNumber) {
        DeanullAddresseeInput request = new DeanullAddresseeInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeType(DataTranslatorExtensions.toContract(addresseeType));
        request.setIdentificationNumber(of.createDeanullAddresseeInputIdentificationNumber(identificationNumber));
        this.context.call().deanullAddressee(request);
    }

    public String addresseeStatusUpdateAsyncStart(AddresseeStatusUpdatePersonType addresseeType, AddresseeStatusUpdateStatusType status, Iterable<String> identificationNumbers) {
        AddresseeStatusUpdateAsyncStartInput request = new AddresseeStatusUpdateAsyncStartInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeType(DataTranslatorExtensions.toContract(addresseeType));
        request.setStatus(DataTranslatorExtensions.toContract(status));
        ArrayOfstring eAddressesArray = new ArrayOfstring();
        eAddressesArray.getString().addAll(Utils.makeCollection(identificationNumbers));
        request.setIdentificationNumbers(of.createAddresseeStatusUpdateAsyncStartInputIdentificationNumbers(eAddressesArray));
        AddresseeStatusUpdateAsyncStartOutput response = this.context.call().addresseeStatusUpdateAsyncStart(request);
        return (String)response.getRequestId().getValue();
    }

    public ListToContinue<AddresseeRecord> getChangedAddresseeRecords(long lastVersion) {
        GetChangedAddresseeRecordListInput request = new GetChangedAddresseeRecordListInput();
        request.setLastVersion(lastVersion);
        GetChangedAddresseeRecordListOutput response = this.context.call().getChangedAddresseeRecordList(request);
        ListToContinue<AddresseeRecord> listAU = new ListToContinue<AddresseeRecord>();
        listAU.setMoreResults(response.isHasMoreData());
        for (lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeRecord a : ((ArrayOfAddresseeRecord)response.getAddresseeRecords().getValue()).getAddresseeRecord()) {
            listAU.add(DataTranslatorExtensions.toData(a));
        }
        return listAU;
    }

    public ResultJournalResult getResultJournal(String requestId) {
        GetResultJournalInput request = new GetResultJournalInput();
        ObjectFactory of = new ObjectFactory();
        request.setRequestId(of.createGetResultJournalInputRequestId(requestId));
        GetResultJournalOutput response = this.context.call().getResultJournal(request);
        return DataTranslatorExtensions.toData(response);
    }

    public String getChangedAddresseeRecordsAsyncStart(long lastVersion) {
        GetChangedAddresseeRecordListAsyncStartInput input = new GetChangedAddresseeRecordListAsyncStartInput();
        input.setLastVersion(lastVersion);
        GetChangedAddresseeRecordListAsyncStartOutput response = this.context.call().getChangedAddresseeRecordListAsyncStart(input);
        return (String)response.getRequestId().getValue();
    }

    public ChangedAddresseeRecordsAsyncResult getChangedAddresseeRecordsAsyncResult(String requestId) {
        GetChangedAddresseeRecordListAsyncResultInput input = new GetChangedAddresseeRecordListAsyncResultInput();
        ObjectFactory of = new ObjectFactory();
        input.setRequestId(of.createGetChangedAddresseeRecordListAsyncResultInputRequestId(requestId));
        GetChangedAddresseeRecordListAsyncResultOutput response = this.context.call().getChangedAddresseeRecordListAsyncResult(input);
        ChangedAddresseeRecordsAsyncResult result = new ChangedAddresseeRecordsAsyncResult();
        result.setError((String)response.getError().getValue());
        result.setFtpFileName((String)response.getFtpFileName().getValue());
        result.setStatus(DataTranslatorExtensions.toData(response.getStatus()));
        return result;
    }

    public void getChangedAddresseeRecordsAsyncConfirm(String requestId) {
        GetChangedAddresseeRecordListAsyncConfirmInput input = new GetChangedAddresseeRecordListAsyncConfirmInput();
        ObjectFactory of = new ObjectFactory();
        input.setRequestId(of.createGetChangedAddresseeRecordListAsyncConfirmInputRequestId(requestId));
        this.context.call().getChangedAddresseeRecordListAsyncConfirm(input);
    }

    public String validateAddresseesAsyncStart(Iterable<String> identificationNumbers) {
        ValidateAddresseesAsyncStartInput input = new ValidateAddresseesAsyncStartInput();
        ObjectFactory of = new ObjectFactory();
        ArrayOfstring arr = new ArrayOfstring();
        arr.getString().addAll(Utils.makeCollection(identificationNumbers));
        input.setIdentificationNumbers(of.createValidateAddresseesAsyncStartInputIdentificationNumbers(arr));
        ValidateAddresseesAsyncStartOutput response = this.context.call().validateAddresseesAsyncStart(input);
        return (String)response.getRequestId().getValue();
    }

    public List<String> validateAddresseesAsyncResult(String requestId) {
        ValidateAddresseesAsyncResultInput input = new ValidateAddresseesAsyncResultInput();
        ObjectFactory of = new ObjectFactory();
        input.setRequestId(of.createValidateAddresseesAsyncResultInputRequestId(requestId));
        ValidateAddresseesAsyncResultOutput response = this.context.call().validateAddresseesAsyncResult(input);
        return ((ArrayOfstring)response.getValidIdentificationNumbers().getValue()).getString();
    }

    public void validateAddresseesAsyncConfirm(String requestId) {
        ValidateAddresseesAsyncConfirmInput input = new ValidateAddresseesAsyncConfirmInput();
        ObjectFactory of = new ObjectFactory();
        input.setRequestId(of.createValidateAddresseesAsyncConfirmInputRequestId(requestId));
        this.context.call().validateAddresseesAsyncConfirm(input);
    }

    public void createAddresseeUnit(AddresseeUnit addresseeUnit) {
        if (addresseeUnit == null) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit");
        }
        if (addresseeUnit.getEAddress() == null || addresseeUnit.getEAddress().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.EAddress");
        }
        if (addresseeUnit.getAddresseeOwnerCode() == null || addresseeUnit.getAddresseeOwnerCode().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.AddresseeOwnerCode");
        }
        if (addresseeUnit.getParentEAddress() == null || addresseeUnit.getParentEAddress().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.ParentEAddress");
        }
        if (addresseeUnit.getTypeCode() == null || addresseeUnit.getTypeCode().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.TypeCode");
        }
        CreateAddresseeUnitInput request = new CreateAddresseeUnitInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeUnit(of.createCreateAddresseeUnitInputAddresseeUnit(DataTranslatorExtensions.toContract(addresseeUnit)));
        this.context.call().createAddresseeUnit(request);
    }

    public void createInstitution(String typeCode, Owner owner) {
        if (typeCode == null || typeCode.isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("typeCode");
        }
        if (owner == null) {
            throw ExceptionBuilder.ArgumentNull("owner");
        }
        CreateInstitutionInput request = new CreateInstitutionInput();
        ObjectFactory of = new ObjectFactory();
        request.setTypeCode(of.createCreateInstitutionInputTypeCode(typeCode));
        request.setOwner(of.createCreateInstitutionInputOwner(DataTranslatorExtensions.toContract(owner)));
        this.context.call().createInstitution(request);
    }

    public void deleteAddresseeUnit(AddresseeUnit addresseeUnit) {
        if (addresseeUnit == null) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit");
        }
        if (addresseeUnit.getEAddress() == null || addresseeUnit.getEAddress().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.EAddress");
        }
        if (addresseeUnit.getAddresseeOwnerCode() == null || addresseeUnit.getAddresseeOwnerCode().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.AddresseeOwnerCode");
        }
        if (addresseeUnit.getVersion() == null) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.Version");
        }
        this.deleteAddresseeUnit(addresseeUnit.getAddresseeOwnerCode(), addresseeUnit.getEAddress(), addresseeUnit.getVersion());
    }

    public void deleteAddresseeUnit(String addresseeOwnerCode, String eAddress, long version) {
        if (eAddress == null || eAddress.isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("EAddress");
        }
        if (addresseeOwnerCode == null || addresseeOwnerCode.isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("AddresseeOwnerCode");
        }
        DeleteAddresseeUnitInput request = new DeleteAddresseeUnitInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeOwnerCode(of.createDeleteAddresseeUnitInputAddresseeOwnerCode(addresseeOwnerCode));
        request.setEAddress(of.createDeleteAddresseeUnitInputEAddress(eAddress));
        request.setVersion(of.createDeleteAddresseeUnitInputVersion(version));
        this.context.call().deleteAddresseeUnit(request);
    }

    public AddresseeUnit getAddresseeUnit(String addresseeOwnerCode, String eAddress) {
        if (eAddress == null || eAddress.isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("EAddress");
        }
        if (addresseeOwnerCode == null || addresseeOwnerCode.isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("AddresseeOwnerCode");
        }
        GetAddresseeUnitInput request = new GetAddresseeUnitInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeOwnerCode(of.createGetAddresseeUnitInputAddresseeOwnerCode(addresseeOwnerCode));
        request.setEAddress(of.createGetAddresseeUnitInputEAddress(eAddress));
        GetAddresseeUnitOutput resp = this.context.call().getAddresseeUnit(request);
        return DataTranslatorExtensions.toData((lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeUnit)resp.getAddresseeUnit().getValue());
    }

    public void updateAddresseeUnit(AddresseeUnit addresseeUnit) {
        this.updateAddresseeUnit(addresseeUnit, null);
    }

    public void updateAddresseeUnit(AddresseeUnit addresseeUnit, String actualEAddress) {
        if (addresseeUnit == null) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit");
        }
        if (addresseeUnit.getEAddress() == null || addresseeUnit.getEAddress().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.EAddress");
        }
        if (addresseeUnit.getAddresseeOwnerCode() == null || addresseeUnit.getAddresseeOwnerCode().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.AddresseeOwnerCode");
        }
        if (addresseeUnit.getVersion() == null) {
            throw ExceptionBuilder.ArgumentNull("addresseeUnit.Version");
        }
        UpdateAddresseeUnitInput request = new UpdateAddresseeUnitInput();
        ObjectFactory of = new ObjectFactory();
        request.setAddresseeUnit(of.createUpdateAddresseeUnitInputAddresseeUnit(DataTranslatorExtensions.toContract(addresseeUnit)));
        request.setActualEAddress(of.createUpdateAddresseeUnitInputActualEAddress(actualEAddress));
        this.context.call().updateAddresseeUnit(request);
    }

    public ListToContinue<AddresseeUnit> searchAddresseeUnits(AddresseeUnitSearchCriteria searchCriteria) {
        if (searchCriteria == null) {
            throw ExceptionBuilder.ArgumentNull("searchCriteria");
        }
        if (searchCriteria.getAddresseeOwnerCode() == null || searchCriteria.getAddresseeOwnerCode().isEmpty()) {
            throw ExceptionBuilder.ArgumentNull("searchCriteria.AddresseeOwnerCode");
        }
        SearchAddresseeUnitInput request = DataTranslatorExtensions.toMessage(searchCriteria);
        SearchAddresseeUnitOutput response = this.context.call().searchAddresseeUnit(request);
        ListToContinue<AddresseeUnit> listAU = new ListToContinue<AddresseeUnit>();
        listAU.setMoreResults(response.isHasMoreData());
        for (lv.gov.vraa.xmlschemas.div.uui._2011._11.AddresseeUnit a : ((ArrayOfAddresseeUnit)response.getAddresseeUnits().getValue()).getAddresseeUnit()) {
            listAU.add(DataTranslatorExtensions.toData(a));
        }
        return listAU;
    }

    public List<EAddressValidationResult> validateEAddress(Iterable<String> eAddresses, AddreesseePersonType type) {
        if (eAddresses == null) {
            throw ExceptionBuilder.ArgumentNull("eAddresses");
        }
        ValidateEAddressInput request = new ValidateEAddressInput();
        ObjectFactory of = new ObjectFactory();
        ArrayOfstring eAddressesArray = new ArrayOfstring();
        eAddressesArray.getString().addAll(Utils.makeCollection(eAddresses));
        request.setEAddresses(of.createValidateEAddressInputEAddresses(eAddressesArray));
        request.setType(DataTranslatorExtensions.toContract(type));
        ValidateEAddressOutput response = this.context.call().validateEAddress(request);
        ArrayList<EAddressValidationResult> listAU = new ArrayList<EAddressValidationResult>();
        for (lv.gov.vraa.xmlschemas.div.uui._2011._11.EAddressValidationResult a : ((ArrayOfEAddressValidationResult)response.getResults().getValue()).getEAddressValidationResult()) {
            listAU.add(DataTranslatorExtensions.toData(a));
        }
        return listAU;
    }

    public void close() {
        this.context = null;
        this.messaging = null;
    }

    public void confirmMessage(IntegrationMessage message) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        this.confirmMessage(message, true, null, null);
    }

    public void confirmMessage(IntegrationMessage message, boolean accept) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        this.confirmMessage(message, accept, null, null);
    }

    public void confirmMessage(IntegrationMessage message, boolean accept, String code, String text) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        this.messaging.confirm(message, accept, code, text);
    }

    public void confirmNotifications(Iterable<?> notificationsOrIds) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Object item : notificationsOrIds) {
            if (item instanceof Long) {
                ids.add((Long)item);
                continue;
            }
            if (!(item instanceof Notification)) continue;
            ids.add(((Notification)item).getId());
        }
        this.confirmNotificationsInternal(ids);
    }

    public void confirmNotifications(long ... notificationIds) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (long l : notificationIds) {
            ids.add(l);
        }
        this.confirmNotificationsInternal(ids);
    }

    public void confirmNotifications(Notification ... notifications) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Notification n : notifications) {
            ids.add(n.getId());
        }
        this.confirmNotificationsInternal(ids);
    }

    public IntegrationMessage getMessage() {
        return this.getMessage(null);
    }

    public IntegrationMessage getMessage(String messageId) {
        return this.messaging.get(messageId);
    }

    public byte[] getMessageFileContent(MessageFile messageFile) {
        if (messageFile == null) {
            throw ExceptionBuilder.ArgumentNull("messageFile");
        }
        return this.getMessageFileContent(messageFile, null);
    }

    public byte[] getMessageFileContent(MessageFile messageFile, FileReceiveContext fileContext) {
        if (messageFile == null) {
            throw ExceptionBuilder.ArgumentNull("messageFile");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.saveMessageFileContent(messageFile, stream, fileContext);
        byte[] result = stream.toByteArray();
        return result;
    }

    public List<IntegrationMessageHeader> getMessageHeaders() {
        return this.getMessageHeaders(null, 50);
    }

    public List<IntegrationMessageHeader> getMessageHeaders(Long addresseeUnitId) {
        return this.getMessageHeaders(addresseeUnitId, 50);
    }

    public ListToContinue<IntegrationMessageHeader> getMessageHeaders(Long addresseeUnitId, int maxResultCount) {
        GetMessageListInput request = new GetMessageListInput();
        ObjectFactory of = new ObjectFactory();
        request.setMaxResultCount(maxResultCount);
        request.setAddresseeUnitId(of.createGetMessageListInputAddresseeUnitId(addresseeUnitId));
        GetMessageListOutput resp = this.context.call().getMessageList(request);
        ListToContinue<IntegrationMessageHeader> res = new ListToContinue<IntegrationMessageHeader>();
        res.setMoreResults(resp.isHasMoreData() == null ? false : resp.isHasMoreData());
        for (MessageHeader m : ((ArrayOfMessageHeader)resp.getMessageHeaders().getValue()).getMessageHeader()) {
            res.add(DataTranslatorExtensions.toData(m));
        }
        return res;
    }

    public List<Notification> getNotifications() {
        return this.getNotifications(50);
    }

    public ListToContinue<Notification> getNotifications(int maxResultCount) {
        GetNotificationListInput request = new GetNotificationListInput();
        request.setMaxResultCount(maxResultCount);
        GetNotificationListOutput response = this.context.call().getNotificationList(request);
        ListToContinue<Notification> res = new ListToContinue<Notification>();
        res.setMoreResults(response.isHasMoreData());
        for (lv.gov.vraa.xmlschemas.div.uui._2011._11.Notification n : ((ArrayOfNotification)response.getNotifications().getValue()).getNotification()) {
            res.add(DataTranslatorExtensions.toData(n));
        }
        return res;
    }

    public MessageServerConfirmation getServerConfirmation(String messageId) {
        if (messageId == null) {
            throw ExceptionBuilder.ArgumentNull("messageId");
        }
        GetMessageServerConfirmationInput request = new GetMessageServerConfirmationInput();
        ObjectFactory of = new ObjectFactory();
        request.setMessageId(of.createGetMessageServerConfirmationInputMessageId(messageId));
        GetMessageServerConfirmationOutput resp = this.context.call().getMessageServerConfirmation(request);
        if (resp.getServerConfirmationPart() == null || resp.getServerConfirmationPart().getServerTransportMetadata() == null) {
            String msg = "incomingServerConfirmEmpty";
            throw ExceptionBuilder.Technical(msg, new Object[0]);
        }
        Element xml = Envelope.serialize(new QName("http://ivis.eps.gov.lv/XMLSchemas/100001/DIV/v1-0", "ServerConfirmationPart"), ServerConfirmationPartStructure.class, resp.getServerConfirmationPart());
        return new MessageServerConfirmation(xml);
    }

    public void saveMessageFileContent(MessageFile messageFile, OutputStream destination) {
        if (messageFile == null) {
            throw ExceptionBuilder.ArgumentNull("messageFile");
        }
        if (destination == null) {
            throw ExceptionBuilder.ArgumentNull("destination");
        }
        this.saveMessageFileContent(messageFile, destination, null);
    }

    public void saveMessageFileContent(MessageFile messageFile, OutputStream destination, FileReceiveContext fileContext) {
        if (messageFile == null) {
            throw ExceptionBuilder.ArgumentNull("messageFile");
        }
        if (destination == null) {
            throw ExceptionBuilder.ArgumentNull("destination");
        }
        FileDecryptor decryptor = null;
        if (fileContext != null) {
            decryptor = fileContext.getDecryptor();
        }
        this.messaging.saveFileContent(messageFile, destination, decryptor);
    }

    public String sendMessage(IntegrationMessage message) {
        if (message == null) {
            throw ExceptionBuilder.ArgumentNull("message");
        }
        return this.messaging.send(message);
    }

    private void confirmNotificationsInternal(List<Long> notificationIds) {
        ConfirmNotificationListInput confirmRequest = new ConfirmNotificationListInput();
        ObjectFactory of = new ObjectFactory();
        ArrayOflong arr = new ArrayOflong();
        arr.getLong().addAll(notificationIds);
        of.createConfirmNotificationListInputNotificationIds(arr);
        confirmRequest.setNotificationIds(of.createConfirmNotificationListInputNotificationIds(arr));
        this.context.call().confirmNotificationList(confirmRequest);
    }
}

