/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import vraa.div.client.ClientException;

public final class ExceptionBuilder {
    public static RuntimeException ArgumentNull(String argumentName) {
        IllegalArgumentException ex = new IllegalArgumentException(argumentName + " is null");
        return ex;
    }

    public static RuntimeException Client(String code, Object ... parameters) {
        String msg = ExceptionBuilder.getMessage("ExceptionBusinessMessages", code, parameters);
        ClientException ex = new ClientException(msg);
        return ex;
    }

    public static RuntimeException Technical(String code, Object ... parameters) {
        String message = ExceptionBuilder.getMessage("ExceptionTechnicalMessages", code, parameters);
        return new RuntimeException(message);
    }

    private static String getMessage(String bundle, String code, Object ... parameters) {
        ResourceBundle bndl = ResourceBundle.getBundle(bundle);
        String message = null;
        try {
            message = bndl.getString(code);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (message == null) {
            message = "#" + code + "#";
        } else {
            try {
                message = MessageFormat.format(message, parameters);
            }
            catch (IllegalArgumentException e) {
                message = "#" + code + "#FORMAT_EXCEPTION";
            }
        }
        return message;
    }

    public static RuntimeException Envelope(String code, Object ... parameters) {
        String message = ExceptionBuilder.getMessage("EnvelopeExceptionMessages", code, parameters);
        return new RuntimeException(message);
    }

    public static RuntimeException Internal(String message, Throwable cause) {
        if (message == null) {
            message = "Internal error";
        }
        return new RuntimeException(message, cause);
    }
}

