/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.ResolutionEntryStructure;
import vraa.div.client.Correspondent;
import vraa.div.client.Officer;
import vraa.div.client.Utils;

public class DocumentResolution {
    private Correspondent addressee;
    private Officer resolutionAuthor;
    private XMLGregorianCalendar resolutionDate;
    private String task;

    public void setAddressee(Correspondent addressee) {
        this.addressee = addressee;
    }

    public Correspondent getAddressee() {
        return this.addressee;
    }

    public void setResolutionAuthor(Officer resolutionAuthor) {
        this.resolutionAuthor = resolutionAuthor;
    }

    public Officer getResolutionAuthor() {
        return this.resolutionAuthor;
    }

    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = Utils.dateToXML(resolutionDate);
    }

    public Date getResolutionDate() {
        return Utils.XMLToDate(this.resolutionDate);
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getTask() {
        return this.task;
    }

    ResolutionEntryStructure getSchemaType() {
        ResolutionEntryStructure s = new ResolutionEntryStructure();
        if (this.resolutionAuthor != null) {
            s.setResolutionAuthor(this.resolutionAuthor.getSchemaType());
        }
        s.setResolutionDate(this.resolutionDate);
        if (this.addressee != null) {
            s.setAddressee(this.addressee.getSchemaType());
        }
        s.setTask(this.task);
        return s;
    }

    void setSchemaType(ResolutionEntryStructure s) {
        if (s.getResolutionAuthor() != null) {
            this.resolutionAuthor = new Officer();
            this.resolutionAuthor.setSchemaType(s.getResolutionAuthor());
        }
        this.resolutionDate = s.getResolutionDate();
        if (s.getAddressee() != null) {
            this.addressee = new Correspondent(s.getAddressee());
        }
        this.task = s.getTask();
    }
}

