/*
 * Decompiled with CFR 0.152.
 */
package vraa.div.client;

import lv.gov.eps.ivis.xmlschemas._100001.div.v1_0.CorrespondentStructure;
import vraa.div.client.InformationSystem;
import vraa.div.client.Institution;
import vraa.div.client.PrivatePerson;

public class Correspondent {
    private Institution institutionData;
    private boolean institution;
    private boolean privatePerson;
    private boolean informationSystem;
    private PrivatePerson privatePersonData;
    private InformationSystem informationSystemData;

    public Correspondent() {
    }

    public Correspondent(Institution institution) {
        this.institutionData = institution;
        this.institution = true;
    }

    public Correspondent(PrivatePerson privatePerson) {
        this.privatePersonData = privatePerson;
        this.privatePerson = true;
    }

    public Correspondent(InformationSystem informationSystem) {
        this.informationSystemData = informationSystem;
        this.informationSystem = true;
    }

    public Institution getInstitutionData() {
        return this.institutionData;
    }

    public boolean isInstitution() {
        return this.institution;
    }

    public boolean isPrivatePerson() {
        return this.privatePerson;
    }

    public boolean isInformationSystem() {
        return this.informationSystem;
    }

    public PrivatePerson getPrivatePersonData() {
        return this.privatePersonData;
    }

    public InformationSystem getInformationSystemData() {
        return this.informationSystemData;
    }

    Correspondent(CorrespondentStructure schemaType) {
        this.setSchemaType(schemaType);
    }

    CorrespondentStructure getSchemaType() {
        CorrespondentStructure schemaItem = new CorrespondentStructure();
        if (this.institution) {
            schemaItem.setInstitution(this.institutionData.getSchemaType());
        } else if (this.privatePerson) {
            schemaItem.setPrivatePerson(this.privatePersonData.getSchemaType());
        } else if (this.informationSystem) {
            schemaItem.setInformationSystem(this.informationSystemData.getSchemaType());
        }
        return schemaItem;
    }

    void setSchemaType(CorrespondentStructure schemaItem) {
        if (schemaItem.getInstitution() != null) {
            this.institutionData = new Institution();
            this.institutionData.setSchemaType(schemaItem.getInstitution());
            this.institution = true;
        } else if (schemaItem.getPrivatePerson() != null) {
            this.privatePersonData = new PrivatePerson();
            this.privatePersonData.setSchemaType(schemaItem.getPrivatePerson());
            this.privatePerson = true;
        } else {
            this.informationSystemData = new InformationSystem();
            this.informationSystemData.setSchemaType(schemaItem.getInformationSystem());
            this.informationSystem = true;
        }
    }
}

