/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.java.xades.util.ISO8601DateFormat;

public class SystemUtils {
    private static final String KEY_PREFIX = "com.cosmos";
    public static final String KEY_APPLICATION_NAME = "com.cosmos.apps.name";
    public static final String KEY_CLIENT_CONFIG_FOLDER = "com.cosmos.apps.client.config.folder";
    public static final String KEY_KEYSTORE_FOLDER = "com.cosmos.key.store.folder";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static DateFormat dateFormat;
    private static DecimalFormat decimalFormat;
    public static String charsetName;

    private static DateFormat getDateFormatter() {
        if (dateFormat == null) {
            dateFormat = new ISO8601DateFormat();
        }
        return dateFormat;
    }

    public static String formatDate(Object date) {
        return SystemUtils.getDateFormatter().format(date);
    }

    public static String formatDate(Date date) {
        return SystemUtils.getDateFormatter().format(date);
    }

    public static Date parseDate(String dateString) throws ParseException {
        DateFormat dateFormat = SystemUtils.getDateFormatter();
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException ex) {
            dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            return dateFormat.parse(dateString);
        }
    }

    public static DecimalFormat getDecimalFormatter() {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat("#,##0.##");
        }
        return decimalFormat;
    }

    public static String getCauseMessages(Throwable ex) {
        if (ex == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SystemUtils.getErrorMessage(ex)).append("; \n");
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            String message = SystemUtils.getErrorMessage(cause);
            if (message == null) continue;
            sb.append(message).append("; \n");
        }
        return sb.toString();
    }

    public static String getErrorMessage(Throwable ex) {
        if (ex != null) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.getClass().getName();
            }
            return message;
        }
        return null;
    }

    public static byte[] toByteArray(InputStream inStream) throws IOException {
        if (inStream == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SystemUtils.copy(inStream, os);
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inStream, OutputStream outStream) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException("InputStream can not be NULL in copy method.");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("OutputStream can not be NULL in copy method.");
        }
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, read);
            }
            outStream.flush();
        }
        finally {
            buffer = null;
            inStream.close();
            inStream = null;
            outStream.close();
        }
    }

    public static String trimFileName(String filePathName) {
        char ch;
        if (filePathName == null) {
            return filePathName;
        }
        StringBuilder sb = new StringBuilder(filePathName);
        int size = sb.length();
        while (size > 0 && ((ch = sb.charAt(size - 1)) == '.' || ch == File.separatorChar)) {
            sb.setLength(--size);
        }
        return sb.toString();
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getIOTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String toHexString(byte[] data) {
        return new String(SystemUtils.toHexChars(data));
    }

    public static char[] toHexChars(byte[] data) {
        if (data == null || data.length <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int size = data.length;
        char[] result = new char[size << 1];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            byte ch = data[i];
            result[j++] = HEX_DIGITS[(ch & 0xF0) >>> 4];
            result[j++] = HEX_DIGITS[ch & 0xF];
        }
        return result;
    }

    static {
        charsetName = "UTF-8";
    }
}

