/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml;

import java.io.File;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.java.xades.security.xml.SignatureStatus;
import net.java.xades.security.xml.WrappedKeyStorePlace;
import net.java.xades.security.xml.XMLSignatureElement;
import net.java.xades.security.xml.XmlWrappedKeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureDocument {
    private Element baseElement;
    private XMLSignatureFactory xmlSignatureFactory;
    private DigestMethod digestMethod;
    private XmlWrappedKeyInfo wrappedKeyInfo = XmlWrappedKeyInfo.CERTIFICATE;
    private List<SignatureProperties> listOfSignatureProperties = new ArrayList<SignatureProperties>();
    private List<SignatureProperty> defaultSignatureProperties = new ArrayList<SignatureProperty>();
    private String defaultSignaturePropertiesId;
    private List<XMLObject> xmlObjects = new ArrayList<XMLObject>();
    private List<XMLStructure> defaultXMLObjectItems = new ArrayList<XMLStructure>();
    private String defaultXMLObjectId;
    private String defaultXMLObjectMimeType;
    private String defaultXMLObjectEncoding;

    public XMLSignatureDocument(Element baseElement) {
        if (baseElement == null) {
            throw new IllegalArgumentException("Root/Base XML Element can not be NULL");
        }
        this.baseElement = baseElement;
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    protected XMLSignatureFactory getXMLSignatureFactory() {
        if (this.xmlSignatureFactory == null) {
            this.xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        return this.xmlSignatureFactory;
    }

    public DigestMethod getDigestMethod() throws GeneralSecurityException {
        if (this.digestMethod == null) {
            this.digestMethod = this.getXMLSignatureFactory().newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        }
        return this.digestMethod;
    }

    public void setDigestMethod(DigestMethod digestMethod) {
        this.digestMethod = digestMethod;
    }

    public List<XMLSignatureElement> getXMLSignatureElements() {
        NodeList nl = this.baseElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int size = nl.getLength();
        ArrayList<XMLSignatureElement> signatureElements = new ArrayList<XMLSignatureElement>(size);
        for (int i = 0; i < size; ++i) {
            signatureElements.add(new XMLSignatureElement((Element)nl.item(i)));
        }
        return signatureElements;
    }

    public XmlWrappedKeyInfo getXmlWrappedKeyInfo() {
        return this.wrappedKeyInfo;
    }

    public void setXmlWrappedKeyInfo(XmlWrappedKeyInfo wrappedKeyInfo) {
        this.wrappedKeyInfo = wrappedKeyInfo;
    }

    public WrappedKeyStorePlace getWrappedKeyStorePlace() {
        return WrappedKeyStorePlace.KEY_INFO;
    }

    public void setWrappedKeyStorePlace(WrappedKeyStorePlace wrappedKeyStorePlace) {
    }

    protected Reference getReference(String uri) throws GeneralSecurityException {
        return this.getReference(uri, null);
    }

    protected Reference getReference(String uri, String type) throws GeneralSecurityException {
        return this.getReference(uri, null, type, null);
    }

    protected Reference getReference(String uri, List transforms, String type) throws GeneralSecurityException {
        return this.getReference(uri, transforms, type, null);
    }

    protected Reference getReference(String uri, List transforms, String type, String referenceId) throws GeneralSecurityException {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        DigestMethod dm = this.getDigestMethod();
        if (!(uri = uri.trim()).startsWith("#")) {
            uri = "#" + uri;
        }
        return fac.newReference(uri, dm, transforms, type, referenceId);
    }

    protected List<Reference> getReferences(List idList) throws GeneralSecurityException {
        ArrayList<Reference> references = new ArrayList<Reference>(idList.size());
        for (Object id : idList) {
            if (id instanceof Reference) {
                references.add((Reference)id);
                continue;
            }
            references.add(this.getReference((String)id));
        }
        return references;
    }

    public List<SignatureStatus> validate() {
        List<XMLSignatureElement> signatureElements = this.getXMLSignatureElements();
        ArrayList<SignatureStatus> validateResult = new ArrayList<SignatureStatus>(signatureElements.size());
        for (XMLSignatureElement signatureElement : signatureElements) {
            validateResult.add(signatureElement.validate());
        }
        return validateResult;
    }

    public void sign(X509Certificate certificate, PrivateKey privateKey, String signatureMethod, List referencesIdList, String signatureIdPrefix, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) throws MarshalException, XMLSignatureException, GeneralSecurityException {
        String signatureId = this.getSignatureId(signatureIdPrefix);
        String signatureValueId = this.getSignatureValueId(signatureIdPrefix);
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
        List<Reference> documentReferences = this.getReferences(referencesIdList);
        String keyInfoId = this.getKeyInfoId(signatureIdPrefix);
        documentReferences.add(fac.newReference("#" + keyInfoId, this.getDigestMethod()));
        SignatureMethod sm = fac.newSignatureMethod(signatureMethod, null);
        SignedInfo si = fac.newSignedInfo(cm, sm, documentReferences);
        XMLSignature signature = fac.newXMLSignature(si, this.newKeyInfo(certificate, keyInfoId), this.getXMLObjects(), signatureId, signatureValueId);
        DOMSignContext signContext = new DOMSignContext(privateKey, (Node)this.baseElement);
        signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix);
        signContext.putNamespacePrefix(xadesNamespace, xadesPrefix);
        signature.sign(signContext);
    }

    protected String getSignatureId(String idPrefix) {
        return idPrefix + "-Signature";
    }

    protected String getSignatureValueId(String idPrefix) {
        return idPrefix + "-SignatureValue";
    }

    protected String getKeyInfoId(String idPrefix) {
        return idPrefix + "-KeyInfo";
    }

    public KeyInfo newKeyInfo(X509Certificate certificate, String keyInfoId) throws KeyException {
        KeyInfoFactory kif = this.getXMLSignatureFactory().getKeyInfoFactory();
        if (XmlWrappedKeyInfo.PUBLIC_KEY.equals((Object)this.getXmlWrappedKeyInfo())) {
            KeyValue kv = kif.newKeyValue(certificate.getPublicKey());
            return kif.newKeyInfo(Collections.singletonList(kv), keyInfoId);
        }
        X509Data certData = kif.newX509Data(Collections.singletonList(certificate));
        return kif.newKeyInfo(Collections.singletonList(certData), keyInfoId);
    }

    public List<SignatureProperties> getListOfSignatureProperties() {
        this.listOfSignatureProperties.add(this.getDefaultSignatureProperties());
        return this.listOfSignatureProperties;
    }

    public void setListOfSignatureProperties(List<SignatureProperties> listOfSignatureProperties) {
        this.listOfSignatureProperties = listOfSignatureProperties;
    }

    public void addSignatureProperty(SignatureProperty signatureProperty) {
        this.defaultSignatureProperties.add(signatureProperty);
    }

    public void addSignatureProperty(List<DOMStructure> content, String target, String id) {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        this.addSignatureProperty(fac.newSignatureProperty(content, target, id));
    }

    public SignatureProperties getDefaultSignatureProperties() {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return fac.newSignatureProperties(this.defaultSignatureProperties, this.defaultSignaturePropertiesId);
    }

    public void setDefaultSignaturePropertiesId(String id) {
        this.defaultSignaturePropertiesId = id;
    }

    public String getDefaultSignaturePropertiesId() {
        return this.defaultSignaturePropertiesId;
    }

    public XMLObject newXMLObject(List<XMLStructure> xmlObjects) {
        return this.newXMLObject(xmlObjects, this.getDefaultXMLObjectId());
    }

    public XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id) {
        return this.newXMLObject(xmlObjects, id, this.getDefaultXMLObjectMimeType());
    }

    public XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id, String mimeType) {
        return this.newXMLObject(xmlObjects, id, mimeType, this.getDefaultXMLObjectEncoding());
    }

    public XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id, String mimeType, String encoding) {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return fac.newXMLObject(xmlObjects, id, mimeType, encoding);
    }

    public XMLObject addXMLObject(List<XMLStructure> xmlObjects) {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return this.addXMLObject(fac.newXMLObject(xmlObjects, this.getDefaultXMLObjectId(), this.getDefaultXMLObjectMimeType(), this.getDefaultXMLObjectEncoding()));
    }

    public XMLObject addXMLObject(XMLObject xmlObject) {
        this.xmlObjects.add(xmlObject);
        return xmlObject;
    }

    public List<XMLObject> getXMLObjects() {
        return this.xmlObjects;
    }

    public void addXMLObjectItem(XMLStructure xmlObjectItem) {
        this.defaultXMLObjectItems.add(xmlObjectItem);
    }

    public XMLObject getDefaultXMLObject() {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return fac.newXMLObject(this.getXMLObjectItems(), this.getDefaultXMLObjectId(), this.getDefaultXMLObjectMimeType(), this.getDefaultXMLObjectEncoding());
    }

    public List<XMLStructure> getXMLObjectItems() {
        return this.defaultXMLObjectItems;
    }

    public void setDefaultXMLObjectId(String defaultXMLObjectId) {
        this.defaultXMLObjectId = defaultXMLObjectId;
    }

    public String getDefaultXMLObjectId() {
        return this.defaultXMLObjectId;
    }

    public void setDefaultXMLObjectMimeType(String defaultXMLObjectMimeType) {
        this.defaultXMLObjectMimeType = defaultXMLObjectMimeType;
    }

    public String getDefaultXMLObjectMimeType() {
        return this.defaultXMLObjectMimeType;
    }

    public void setDefaultXMLObjectEncoding(String defaultXMLObjectEncoding) {
        this.defaultXMLObjectEncoding = defaultXMLObjectEncoding;
    }

    public String getDefaultXMLObjectEncoding() {
        return this.defaultXMLObjectEncoding;
    }

    private static Document loadEncryptionDocument() throws Exception {
        String fileName = "BluesRecorderPro.log.wse";
        File encryptionFile = new File(fileName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(encryptionFile);
        System.out.println("Encryption document loaded from " + encryptionFile.toString());
        return document;
    }

    public static void printDocument(Node node) throws TransformerException {
        PrintStream os = System.out;
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(node), new StreamResult(os));
    }
}

