/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml.XAdES;

import java.security.GeneralSecurityException;
import java.util.Date;
import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifier;
import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifierDetails;
import net.java.xades.security.xml.XAdES.SignatureProductionPlace;
import net.java.xades.security.xml.XAdES.SignatureProductionPlaceDetails;
import net.java.xades.security.xml.XAdES.SignedProperties;
import net.java.xades.security.xml.XAdES.Signer;
import net.java.xades.security.xml.XAdES.SignerDetails;
import net.java.xades.security.xml.XAdES.SignerRole;
import net.java.xades.security.xml.XAdES.SignerRoleDetails;
import net.java.xades.security.xml.XAdES.SigningCertificate;
import net.java.xades.security.xml.XAdES.SigningCertificateDetails;
import net.java.xades.security.xml.XAdES.SigningTime;
import net.java.xades.security.xml.XAdES.XAdESStructure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignedSignatureProperties
extends XAdESStructure {
    private Document document;

    public SignedSignatureProperties(Document document, SignedProperties sp, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(document, sp, "SignedSignatureProperties", xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        this.document = document;
    }

    public SignedSignatureProperties(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public void setSigningTime() {
        this.setSigningTime(new Date());
    }

    public void setSigningTime(Date signingTime) {
        new SigningTime(this.document, this, signingTime, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
    }

    public void setSigner(Signer signer) {
        new SignerDetails(this.document, this, signer, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
    }

    public void setSigningCertificate(SigningCertificate signingCertificate) throws GeneralSecurityException {
        if (signingCertificate != null) {
            new SigningCertificateDetails(this.document, this, signingCertificate, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
    }

    public void setSignerRole(SignerRole signerRole) {
        if (signerRole != null && (signerRole.getClaimedRole().size() > 0 || signerRole.getCertifiedRole().size() > 0)) {
            new SignerRoleDetails(this.document, this, signerRole, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
    }

    public Signer getSigner() {
        SignerDetails details = this.getSignerDetails();
        if (details != null) {
            Signer signer = details.getSigner();
            return signer;
        }
        return null;
    }

    protected SignerDetails getSignerDetails() {
        Element element = this.getChildElementNS("SignerDetails");
        if (element != null) {
            return new SignerDetails(element, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
        return null;
    }

    public void setSignatureProductionPlace(SignatureProductionPlace signatureProductionPlace) {
        if (signatureProductionPlace != null) {
            new SignatureProductionPlaceDetails(this.document, this, signatureProductionPlace, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
    }

    public void setSignaturePolicyIdentifier(SignaturePolicyIdentifier signaturePolicyIdentifier) {
        if (signaturePolicyIdentifier != null) {
            new SignaturePolicyIdentifierDetails(this.document, this, signaturePolicyIdentifier, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
    }
}

