/*
 * Decompiled with CFR 0.152.
 */
package net.java.xades.security.xml.XAdES;

import net.java.xades.security.xml.XAdES.SignaturePolicyIdentifier;
import net.java.xades.security.xml.XAdES.SignedSignatureProperties;
import net.java.xades.security.xml.XAdES.XAdESStructure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignaturePolicyIdentifierDetails
extends XAdESStructure {
    public SignaturePolicyIdentifierDetails(Document document, SignedSignatureProperties signedSignatureProperties, SignaturePolicyIdentifier signaturePolicyIdentifier, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(document, signedSignatureProperties, "SignaturePolicyIdentifier", xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        if (signaturePolicyIdentifier.isImplied()) {
            Element implied = this.createElement("SignaturePolicyImplied");
            this.getNode().appendChild(implied);
        } else {
            Element signaturePolicyId = this.createElement("SignaturePolicyId");
            Element identifier = this.createElement("Identifier");
            identifier.appendChild(this.getDocument().createTextNode(signaturePolicyIdentifier.getIdentifier()));
            Element description = this.createElement("Description");
            description.appendChild(this.getDocument().createTextNode(signaturePolicyIdentifier.getDescription()));
            Element sigPolicyId = this.createElement("SigPolicyId");
            sigPolicyId.appendChild(identifier);
            sigPolicyId.appendChild(description);
            signaturePolicyId.appendChild(sigPolicyId);
            Element digestMethod = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "DigestMethod");
            Element digestValue = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "DigestValue");
            digestValue.setTextContent(signaturePolicyIdentifier.getHashBase64());
            Element sigPolicyHash = this.createElement("SigPolicyHash");
            sigPolicyHash.appendChild(digestMethod);
            sigPolicyHash.appendChild(digestValue);
            signaturePolicyId.appendChild(sigPolicyHash);
            if (signaturePolicyIdentifier.getQualifier() != null) {
                Element spURI = this.createElement("SPURI");
                spURI.setTextContent(signaturePolicyIdentifier.getQualifier());
                Element sigPolicyQualifier = this.createElement("SigPolicyQualifier");
                sigPolicyQualifier.appendChild(spURI);
                Element sigPolicyQualifiers = this.createElement("SigPolicyQualifiers");
                sigPolicyQualifiers.appendChild(sigPolicyQualifier);
                signaturePolicyId.appendChild(sigPolicyQualifiers);
            }
            this.getNode().appendChild(signaturePolicyId);
        }
    }
}

