﻿namespace Viss.DIT.WS.Samples.SendReplay
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using System.Xml;
    using ProxyToService;
    using System.Linq;
    using ProxyToService.DitService;

    public class Program
    {
        public static void Main(string[] args)
        {
            string channelName = "SampleChannel7";
            string channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";
            string messageId = string.Empty;

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageService"))
            {
                try
                {
                    ProxyToService.DitService.MessageSaveStructure2 message = new ProxyToService.DitService.MessageSaveStructure2();
                    message.ChannelVersionURN = channelVersionURN;
                    BussinesMessageType bussinesMessage = new BussinesMessageType();
                    XmlDocument xml = new XmlDocument();
                    xml.Load("../../../data.xml");
                    bussinesMessage.Any = xml.DocumentElement;

                    message.Item = bussinesMessage;
                    message.ReceiverFilter = new ReceiverFilterArrayStructure() { Authority = new string[] { "100001" } };
                    bool resp = client.SendMessage2(message);

                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }
            }

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageServiceUser"))
            {
                var applyTo = new Uri("https://ivis.eps.gov.lv/DIT.WebService");
                var factory = client.ChannelFactory;
                var other = factory.Endpoint.Behaviors.Find<ClientCredentials>();
                factory.Endpoint.Behaviors.Remove(other.GetType());
                var item1 = new ApplyToClientCredentials(other) { ApplyTo = applyTo };
                factory.Endpoint.Behaviors.Add(item1);

                try
                {
                    client.ClientCredentials.UserName.UserName = System.Configuration.ConfigurationManager.AppSettings.Get("VraaUserName");
                    client.ClientCredentials.UserName.Password = System.Configuration.ConfigurationManager.AppSettings.Get("VraaPassword");

                    MessageRequestStructure messageRequest = new MessageRequestStructure();
                    messageRequest.Item = channelVersionURN;
                    messageRequest.ItemElementName = ItemChoiceType.ChannelVersionURN;

                    MessageResponseStructure2 resp = client.ReceiveMessage2(messageRequest);
                    
                    messageId = resp.Items?.FirstOrDefault()?.MessageID;
                    Console.WriteLine("ReceiveMessage");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }
            }

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageService"))
            {
                var applyTo = new Uri("https://ivis.eps.gov.lv/DIT.WebService");
                var factory = client.ChannelFactory;
                var other = factory.Endpoint.Behaviors.Find<ClientCredentials>();
                factory.Endpoint.Behaviors.Remove(other.GetType());
                var item = new ApplyToClientCredentials(other) { ApplyTo = applyTo };
                factory.Endpoint.Behaviors.Add(item);

                try
                {
                    ProxyToService.DitService.MessageSaveStructure2 message = new ProxyToService.DitService.MessageSaveStructure2();
                    message.ChannelVersionURN = channelVersionURN;

                    EventMessageType eventMessage = new EventMessageType();
                    eventMessage.Name = "Error!";
                    eventMessage.RelatedMessageID = messageId;

                    XmlDocument xml = new XmlDocument();
                    xml.Load("../../../kluda.xml");
                    eventMessage.Any = xml.DocumentElement;
                    message.Item = eventMessage;

                    bool resp2 = client.SendMessage2(message);

                    Console.WriteLine("message was sent");
                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}
