﻿// ----------------------------------------------------------------------------
// <copyright file="Program.cs" company="ABC software">
//    Copyright © ABC SOFTWARE. All rights reserved.
//    The source code or its parts to use, reproduce, transfer, copy or
//    keep in an electronic form only from written agreement ABC SOFTWARE.
// </copyright>
// ----------------------------------------------------------------------------

namespace Viss.DIT.WS.Samples.RestoreMessage
{
    using System;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using System.Xml;
    using ProxyToService;
    using ProxyToService.DitService;

    /// <summary>
    /// class Programm
    /// </summary>
    public static class Program
    {
        /// <summary>
        /// Mains the specified args.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            string channelName = "SampleChannel7";
            string channelURN = "URN:IVIS:100001:CHA-" + channelName + "-TYPE-DIK";
            string channelVersionURN = "URN:IVIS:100001:CHA-" + channelName + "-v1-0-TYPE-DIK";

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageService"))
            {
                try
                {
                    ProxyToService.DitService.MessageSaveStructure2 message = new ProxyToService.DitService.MessageSaveStructure2();
                    message.ChannelVersionURN = channelVersionURN;
                    BussinesMessageType bussinesMessage = new BussinesMessageType();
                    XmlDocument xml = new XmlDocument();
                    xml.Load("../../../data.xml");
                    bussinesMessage.Any = xml.DocumentElement;

                    message.Item = bussinesMessage;
                    message.ReceiverFilter = new ReceiverFilterArrayStructure()
                    {
                        Authority = new[] { "100001" }
                    };
                    bool resp = client.SendMessage2(message);
                    
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }
            }

            using (ProxyToService.DitService.DITMessageServiceContractClient client = new ProxyToService.DitService.DITMessageServiceContractClient("MessageServiceUser"))
            {
                var applyTo = new Uri("https://ivis.eps.gov.lv/DIT.WebService");
                var factory = client.ChannelFactory;
                var other = factory.Endpoint.Behaviors.Find<ClientCredentials>();
                factory.Endpoint.Behaviors.Remove(other.GetType());
                var item1 = new ApplyToClientCredentials(other) { ApplyTo = applyTo };
                factory.Endpoint.Behaviors.Add(item1);

                try
                {
                    client.ClientCredentials.UserName.UserName = System.Configuration.ConfigurationManager.AppSettings.Get("VraaUserName");
                    client.ClientCredentials.UserName.Password = System.Configuration.ConfigurationManager.AppSettings.Get("VraaPassword");

                    MessageRequestStructure messageRequest = new MessageRequestStructure();
                    messageRequest.Item = channelVersionURN;
                    messageRequest.ItemElementName = ItemChoiceType.ChannelVersionURN;

                    MessageResponseStructure2 resp = client.ReceiveMessage2(messageRequest);
                    Console.WriteLine("ReceiveMessage");

                    MessageListRequestStructure messageListRequest = new MessageListRequestStructure();
                    messageListRequest.Item = channelVersionURN;
                    messageListRequest.ItemElementName = ItemChoiceType.ChannelVersionURN;

                    messageListRequest.ReadMessage = true;
                    messageListRequest.ReadMessageSpecified = true;

                    MessageBasicInfoListStructure receiveMessageList = client.ReceiveMessageList(messageListRequest);
                    Console.WriteLine("ReceiveMessageList");

                    if (receiveMessageList != null && receiveMessageList.MessageBasicInfo != null)
                    {
                        MessageBasicInfoListStructure messageBasicInfoList = new MessageBasicInfoListStructure();
                        messageBasicInfoList.MessageBasicInfo = new MessageBasicInfoStructure[receiveMessageList.MessageBasicInfo.Length];

                        int i = 0;

                        foreach (var item in receiveMessageList.MessageBasicInfo)
                        {
                            messageBasicInfoList.MessageBasicInfo[i] = item;
                        }

                        bool data = Helper.InvokeIgnoreException<bool, FaultException>(() => client.RestoreMessageList(messageBasicInfoList), "statuss \"Pegādāts\" vairs nevar tikt mainīts uz statusu \"Pegādāts\"!");

                        
                    }

                    MessageResponseStructure2 messageResponse = client.ReceiveMessage2(messageRequest);

                    if (messageResponse != null && messageResponse.Items != null)
                    {
                        foreach (var item in messageResponse.Items)
                        {
                            Console.WriteLine("message receved id:" + item.MessageID);
                            MessageRequestStructure messageRequestDelete = new MessageRequestStructure();
                            messageRequestDelete.Item = item.MessageID;
                            messageRequestDelete.ItemElementName = ItemChoiceType.MessageID;
                            client.DeleteMessage(messageRequestDelete);
                            Console.WriteLine("message deleted id:" + item.MessageID);
                        }
                    }

                    Console.WriteLine("Press key...");
                }
                catch (CommunicationException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (TimeoutException e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);

                    client.Abort();
                }
                catch (Exception e)
                {
                    string mess = e.Message;
                    Console.WriteLine(mess);
                    client.Abort();
                    throw;
                }

                Console.ReadLine();
            }
        }
    }
}